% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadableReactTable.R
\name{downloadableReactTable}
\alias{downloadableReactTable}
\title{downloadableReactTable module server function}
\usage{
downloadableReactTable(
  id,
  table_data,
  selection_mode = NULL,
  pre_selected_rows = NULL,
  file_name_root = "data_file",
  download_data_fxns = NULL,
  pagination = FALSE,
  table_height = 600,
  show_rownames = FALSE,
  columns_filter = FALSE,
  global_search = TRUE,
  row_highlight = TRUE,
  row_striping = TRUE,
  table_options = list(),
  logger = NULL
)
}
\arguments{
\item{id}{the ID of the Module's UI element}

\item{table_data}{reactive expression (or parameter-less function) that acts as table data source}

\item{selection_mode}{to enable row selection, set \code{selection_mode} value to either "single" for single row
selection or "multiple" for multiple rows selection, case insensitive. Any other value will
disable row selection. Row selection will be enabled by radio buttons in "single" selection
and checkboxes in "multiple" selection (default = NULL)}

\item{pre_selected_rows}{reactive expression (or parameter-less function) provides the rows indices of the rows to
be selected when the table is rendered. If selection_mode is disabled, this parameter will
have no effect. If selection_mode is "single" only the first row index will be used (default = NULL)}

\item{file_name_root}{the base name used for user-downloaded file. It can be either a character string
a reactive expression or a function returning a character string (default = 'data_file')}

\item{download_data_fxns}{a \strong{named} list of functions providing the data as return values.
The names for the list should be the same names as the ones used in the
downloadableReactTableUI (default = NULL)}

\item{pagination}{to enable table pagination (default = FALSE)}

\item{table_height}{max table height in pixels. Vertical scroll will be shown after that height value}

\item{show_rownames}{enable displaying rownames as a separate column (default = FALSE)}

\item{columns_filter}{enable the filtering input on each column in the table (default = FALSE)}

\item{global_search}{enable table global searching input to search and filter in all columns at once
(default = TRUE)}

\item{row_highlight}{enable highlighting rows upon mouse hover (default = TRUE)}

\item{row_striping}{add zebra-striped style to table rows (default = TRUE)}

\item{table_options}{optional table formatting parameters check \code{?reactable::reactable} for options full list.
Also see example below to see how to pass options (default = list())}

\item{logger}{logger to use (default = NULL)}
}
\value{
A named list of two elements:
\itemize{
\item selected_rows: data.frame of current selected rows
\item table_state: a list of the current table state. The list keys are
("page", "pageSize", "pages", "sorted" and "selected").
Review \code{?reactable::getReactableState} for more info.
}
}
\description{
Server-side function for the downloadableReactTableUI.
}
\section{Shiny Usage}{

This function is not called directly by consumers - it is accessed in
server.R using the same id provided in \code{downloadableReactTableUI}:

\strong{\code{downloadableReactTable(id)}}
}

\examples{
if (interactive()) {
 library(shiny)
 library(periscope2)
 library(reactable)

 shinyApp(
     ui = fluidPage(fluidRow(column(
         width = 12,
         downloadableReactTableUI(
             id            = "object_id1",
             downloadtypes = c("csv", "tsv"),
             hovertext     = "Download the data here!")))),
     server = function(input, output) {
         table_state <- downloadableReactTable(
             id                 = "object_id1",
             table_data         = reactiveVal(iris),
             download_data_fxns = list(csv = reactiveVal(iris), tsv = reactiveVal(iris)),
             selection_mode     = "multiple",
             pre_selected_rows  = function() {c(1, 3, 5)},
             table_options      = list(columns = list(
                 Sepal.Length = colDef(name = "Sepal Length"),
                 Sepal.Width  = colDef(filterable = TRUE),
                 Petal.Length = colDef(show = FALSE),
                 Petal.Width  = colDef(defaultSortOrder = "desc")),
                 theme = reactableTheme(
                     borderColor = "#dfe2e5",
                     stripedColor = "#f6f8fa",
                     highlightColor = "#f0f5f9",
                     cellPadding = "8px 12px")))

        observeEvent(table_state(), { print(table_state()) })
    })
}

}
\seealso{
\link[periscope2]{downloadableReactTableUI}

\link[periscope2]{downloadFileButton}

\link[periscope2]{logViewerOutput}

\link[periscope2]{downloadFile}

\link[periscope2]{downloadFile_ValidateTypes}

\link[periscope2]{downloadFile_AvailableTypes}

\link[periscope2]{downloadablePlot}
}
