% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_group.R
\name{strat_permute_group}
\alias{strat_permute_group}
\title{Stratified group permutation}
\usage{
strat_permute_group(df, group_col, strata_col, seed = NULL)
}
\arguments{
\item{df}{A data frame}

\item{group_col}{The name of the column in df that corresponds to the group label}

\item{strata_col}{The name of the column in df that corresponds to the strata}

\item{seed}{An integer seed value}
}
\value{
The inputted data frame with the group column randomly shuffled by strata
}
\description{
This function takes a data frame and group and strata column name as input
and returns the dataframe with the group column randomly permuted by strata
}
\examples{
data <- data.frame(group_label = c(1, 2, 2, 1, 2, 1), stratum = c(1, 1, 1, 2, 2, 2), outcome = 1:6)
permute_group(df = data, group_col = "group_label", strata_col = "stratum", seed = 42)

}
