% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation_test.R
\name{two_sample}
\alias{two_sample}
\title{Two-sample permutation test}
\usage{
two_sample(x, y, shift = 0, alternative = "greater", reps = 10^4, seed = NULL)
}
\arguments{
\item{x}{array of data for treatment group}

\item{y}{array of data for control group}

\item{shift}{Value of shift to apply in two-sample problem}

\item{alternative}{String, two-sided or one-sided (greater or less) p-value; options are 'greater', 'less', or 'two-sided'}

\item{reps}{Number of iterations to use when calculating permutation p-value}

\item{seed}{An integer seed value}
}
\value{
The permutation test p-value
}
\description{
This function runs a permutation test with difference in means test statistic
for the two-sample problem by calling
the permutation_test function.
}
\examples{
two_sample(x = c(10, 9, 11), y = c(12, 11, 13), alternative = "less", seed = 42)

}
