% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curvefit.R
\name{curvefit}
\alias{curvefit}
\title{Fine curve fitting}
\usage{
curvefit(
  y,
  t = index(y),
  tout = t,
  methods = c("AG", "Beck", "Elmore", "Gu", "Klos", "Zhang"),
  w = NULL,
  ...,
  type = 1L,
  use.cpp = FALSE
)
}
\arguments{
\item{y}{Vegetation time-series index, numeric vector}

\item{t}{The corresponding doy of x}

\item{tout}{The output interpolated time.}

\item{methods}{Fine curve fitting methods, can be one or more of \code{c('AG', 'Beck', 'Elmore', 'Gu', 'Klos', 'Zhang')}.}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{...}{other parameters passed to curve fitting function.}

\item{type}{integer, \code{1} or \code{-1}
\itemize{
\item \code{1}: trough-to-trough curve fitting
\item \code{-1}: peak-to-peak curve fitting
}}

\item{use.cpp}{(unstable, not used) boolean, whether to use c++ defined fine
fitting function? If \code{FALSE}, R version will be used.}
}
\value{
fFITs S3 object, see \code{\link[=fFITs]{fFITs()}} for details.
}
\description{
Curve fit vegetation index (VI) time-series of every growing season using
fine curve fitting methods.
}
\note{
'Klos' have too many parameters. It will be slow and not stable.
}
\examples{
library(phenofit)
# simulate vegetation time-series
FUN = doubleLog.Beck
par = c(mn  = 0.1, mx  = 0.7, sos = 50, rsp = 0.1, eos = 250, rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- FUN(par, t)

methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fit <- curvefit(y, t, tout = tout, methods)
}
\seealso{
\code{\link[=fFITs]{fFITs()}}
}
