% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-relations.R
\name{phint_overlaps}
\alias{phint_overlaps}
\title{Test whether two phintervals overlap}
\usage{
phint_overlaps(phint1, phint2, bounds = c("[]", "()"))
}
\arguments{
\item{phint1, phint2}{\verb{[phinterval / Interval]}

A pair of \verb{<phinterval>} or \verb{<Interval>} vectors. \code{phint1} and \code{phint2}
are recycled to a common length using vctrs-style recycling.}

\item{bounds}{\verb{["[]" / "()"]}

Whether span endpoints are inclusive or exclusive:
\itemize{
\item \code{"[]"} (default): Closed intervals - both endpoints are included
\item \code{"()"}: Open intervals - both endpoints are excluded
}

This affects adjacency and overlap detection. For example, with \code{bounds = "[]"},
the intervals \verb{[1, 5]} and \verb{[5, 10]} are considered adjacent (they share the
endpoint 5), while with \code{bounds = "()"}, \verb{(1, 5)} and \verb{(5, 10)} are disjoint
(neither includes 5).}
}
\value{
A logical vector.
}
\description{
\code{phint_overlaps()} tests whether the i-th element of \code{phint1} overlaps with
the i-th element of \code{phint2}, returning a logical vector. Adjacent intervals
(where one ends exactly when the other begins) are considered overlapping.
\code{phint1} and \code{phint2} are recycled to their common length using vctrs-style
recycling rules.
}
\examples{
monday <- interval(as.Date("2025-11-10"), as.Date("2025-11-11"))
tuesday <- interval(as.Date("2025-11-11"), as.Date("2025-11-12"))
friday <- interval(as.Date("2025-11-14"), as.Date("2025-11-15"))
mon_and_fri <- phint_union(monday, friday)

phint_overlaps(c(monday, monday, friday), c(mon_and_fri, friday, NA))

# Adjacent intervals are considered overlapping by default
phint_overlaps(monday, tuesday)

# Use exclusive bounds to consider adjacent intervals as disjoint
phint_overlaps(monday, tuesday, bounds = "()")

# Holes never overlap with anything (including other holes)
hole <- hole()
phint_overlaps(c(hole, monday), c(hole, hole))

}
