% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uvi.wb.r
\name{UVI_wb}
\alias{UVI_wb}
\title{Constructor of CIE weighted waveband}
\usage{
UVI_wb(std = "NOAA")
}
\arguments{
\item{std}{"NOAA" or "WMO"}
}
\value{
a list defining the wavelength range, weighting and normalization.
  This is just the CIE98 BSWF but with the wavelength limits adjusted to
  those used for UVI.
}
\description{
This is just a convenience function that returns the same
  weights as \code{CIE} as defined by \code{CIE_e_fun} but with no option to
  change normalization wavelength, and with the wavelength limits adjusted to
  those used for UVI. Using std="NOAA" follows the definition in
  \url{https://www.esrl.noaa.gov/gmd/grad/neubrew/docs/UVindex.pdf} but using
  CIE98 as SWF. NOAA definition discards wavelengths shorter than 286.5 nm as
  when calculated based on spectral data from Brewer instruments. "WMO" uses
  the internationally accepted lower limit at 250 nm. "NOAA" is the default
  as this is safer with noisy data for sunlight, and for solar radiation the
  value of UVI should be correct. When calculating UVI for radiation spectra
  from UV lamps, "WMO" should be used.
}
\details{
UVI (UV Index) based on Erythema BSWF
}
\references{
World Health Organization, World Meteorological Organization,
  United Nations Environment Programme & International Commission on
  Non-Ionizing Radiation Protection.  (2002) Global Solar UV Index: A
  Practical Guide. World Health Organization, Geneva. ISBN 9241590076.
  \url{https://apps.who.int/iris/handle/10665/42459}

P. Kiedron, S. Stierle and K. Lantz (2007) Instantaneous UV Index and Daily
UV Dose Calculations. NOAA-EPA Brewer Network.
\url{https://www.esrl.noaa.gov/gmd/grad/neubrew/docs/UVindex.pdf}
}
\seealso{
\code{\link{UVI}} and \code{\link[photobiology]{waveband}}
}
\keyword{internal}
