test_that("green waveband is correct for default", {
  expect_equal(Green(), Green("ISO"))
})

test_that("Green waveband is correct for \"ISO\"", {
  wb <- Green(std = "ISO")
  expect_equal(wl_range(wb), c(500, 570))
  expect_equal(wl_range(wb), range(Green()))
  expect_equal(wl_range(wb), range(Green("ISO")))
  expect_equal(labels(wb)$label, "Green")
  expect_equal(labels(wb)$name, "Green.ISO")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"Sellaro\"", {
  wb <- Green(std = "Sellaro")
  expect_equal(wl_range(wb), c(500, 570))
  expect_equal(labels(wb)$label, "Green")
  expect_equal(labels(wb)$name, "Green.Sellaro")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"broad\"", {
  wb <- Green(std = "broad")
  expect_equal(wl_range(wb), c(500, 600))
  expect_equal(labels(wb)$label, "Green")
  expect_equal(labels(wb)$name, "Green.broad")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"RS\"", {
  wb <- Green(std = "RS")
  expect_equal(wl_range(wb), c(525, 600))
  expect_equal(labels(wb)$label, "Green")
  expect_equal(labels(wb)$name, "Green.RS")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatTM\"", {
  wb <- Green(std = "LandsatTM")
  expect_equal(wl_range(wb), c(520, 600))
  expect_equal(labels(wb)$label, "Green")
  expect_equal(labels(wb)$name, "Green.LandsatTM")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatETM\"", {
  wb <- Green(std = "LandsatETM")
  expect_equal(wl_range(wb), c(520, 600))
  expect_equal(labels(wb)$label, "Green")
  expect_equal(labels(wb)$name, "Green.LandsatETM")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatOLI\"", {
  wb <- Green(std = "LandsatOLI")
  expect_equal(wl_range(wb), c(525, 600))
  expect_equal(labels(wb)$label, "Green")
  expect_equal(labels(wb)$name, "Green.LandsatOLI")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatRBV\"", {
  wb <- Green(std = "LandsatRBV")
  expect_equal(wl_range(wb), c(480, 580))
  expect_equal(labels(wb)$label, "Green")
  expect_equal(labels(wb)$name, "Green.LandsatRBV")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("wl range is correct for \"LandsatMSS\"", {
  wb <- Green(std = "LandsatMSS")
  expect_equal(wl_range(wb), c(500, 600))
  expect_equal(labels(wb)$label, "Green")
  expect_equal(labels(wb)$name, "Green.LandsatMSS")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_equal(length(wb$hinges), 4L)
})

test_that("Green waveband is correct for bad std", {
  expect_warning(wb <- Green(std = "bad-std"))
  expect_equal(wl_range(wb), c(NA_real_, NA_real_))
  expect_equal(labels(wb)$label, "Not available")
  expect_equal(labels(wb)$name, "Not available")
  expect_equal(wb$weight, "none")
  expect_null(wb$SWF.e.fub)
  expect_null(wb$SWF.q.fub)
  expect_null(wb$norm)
  expect_type(wb$hinges, "double")
  expect_true(all(is.na(wb$hinges)))
  expect_equal(length(wb$hinges), 4L)
})
