% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.metadata.r
\name{setWhereMeasured}
\alias{setWhereMeasured}
\alias{where_measured<-}
\alias{setWhereMeasured.default}
\alias{setWhereMeasured.generic_spct}
\alias{setWhereMeasured.summary_generic_spct}
\alias{setWhereMeasured.data.frame}
\alias{setWhereMeasured.generic_mspct}
\title{Set the "where.measured" attribute}
\usage{
setWhereMeasured(x, where.measured, lat, lon, address, ...)

where_measured(x) <- value

\method{setWhereMeasured}{default}(x, where.measured, lat, lon, address, ...)

\method{setWhereMeasured}{generic_spct}(
  x,
  where.measured = NA,
  lat = NA,
  lon = NA,
  address = NA,
  idFactor = getIdFactor(x),
  simplify = TRUE,
  ...
)

\method{setWhereMeasured}{summary_generic_spct}(
  x,
  where.measured = NA,
  lat = NA,
  lon = NA,
  address = NA,
  idFactor = getIdFactor(x),
  simplify = TRUE,
  ...
)

\method{setWhereMeasured}{data.frame}(
  x,
  where.measured = NA,
  lat = NA,
  lon = NA,
  address = NA,
  idFactor = getIdFactor(x),
  simplify = TRUE,
  ...
)

\method{setWhereMeasured}{generic_mspct}(x, where.measured = NA, lat = NA, lon = NA, address = NA, ...)
}
\arguments{
\item{x}{an R object}

\item{where.measured, value}{A one row \code{data.frame} with the same format
as returned by function \code{geocode} from package 'ggmap' for a location
search.}

\item{lat}{numeric Latitude in decimal degrees North.}

\item{lon}{numeric Longitude in decimal degrees West.}

\item{address}{character Human readable address.}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{idFactor}{character Name of the column with IDs of the spectra stored
in long form or ID column name in bound geocodes to use for IDs of
collection of spectra members.}

\item{simplify}{logical If all members share the same geocode value set as
attribute value a one row geocode instead of a named list of data frames.}
}
\value{
x, with the \code{"where.measured"} attribute set or unset.
}
\description{
Method to set by reference the \code{"where.measured"} attribute  of an R
object.
}
\details{
Code \code{setWhereMeasured()} methods alter \code{x} itself by
  reference and in addition return \code{x} invisibly. If \code{x} is not an
  object of a supported class, \code{x} is not modified. If the argument to
  \code{where.measured} is not a \code{data.frame} or \code{tibble} object or
  \code{NULL} an error is triggered as a validation test is applied. A
  geocode describes a geographic location based on longitude (\code{lon}) and
  latitude (\code{lat}) as \code{numeric} values and can optionally contain
  an address (\code{address}) as a single \code{character} string. Passing
  \code{NULL} as argument for parameter \code{where.measured} unsets the
  attribute. Parameters \code{lon}, \code{lat} and \code{address} provide an
  alternative to passing a ready constructed geocode data frame as input.

  By default, when setting the geocode attribute for multiple spectra stored
  in long form, geocodes are stored as named lists of data frames unless they
  are identical and can be simplified. It is possible to
  disable simplification and force the use of a named list.

  If the argument passed to parameter \code{geocode} is a data frame with one
  row per spectrum and the \code{idFactor} name matches, it will be split
  into a named list and, if possibly, simplified. It is also possible but
  deprecated to set the attribute to an indexed geocode with multiple rows.
}
\section{Methods (by class)}{
\itemize{
\item \code{setWhereMeasured(default)}: default

\item \code{setWhereMeasured(generic_spct)}: generic_spct

\item \code{setWhereMeasured(summary_generic_spct)}: summary_generic_spct

\item \code{setWhereMeasured(data.frame)}: data.frame

\item \code{setWhereMeasured(generic_mspct)}: generic_mspct

}}
\note{
Method for collections of spectra recycles the location information
  only if it is a one row \code{data.frame}.
}
\examples{
my.spct <- sun.spct
where_measured(my.spct)
where_measured(my.spct) <- data.frame(lon = 0, lat = -60)
where_measured(my.spct)
where_measured(my.spct) <- NULL
where_measured(my.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{add_attr2tb}()},
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getSoluteProperties}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhenMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setSoluteProperties}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{spct_metadata}()},
\code{\link{subset_attributes}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
