% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FvCB.R
\name{J}
\alias{J}
\title{J: Rate of electron transport (umol/m^2/s)}
\usage{
J(pars, unitless = FALSE)
}
\arguments{
\item{pars}{Concatenated parameters (\code{leaf_par}, \code{enviro_par}, and \code{constants})}

\item{unitless}{Logical. Should \code{units} be set? The function is faster when FALSE, but input must be in correct units or else results will be incorrect without any warning.}
}
\value{
Value in \eqn{\mu}mol/ (m^2 s) of class \code{units}
}
\description{
Calculate the rate of electron transport as a function of photosynthetic photon flux density (PPFD).
}
\details{
\eqn{J} as a function of PPFD is the solution to the quadratic expression:

\deqn{0 = \theta_J J ^ 2 - J (J_\mathrm{max} + \phi_J PPFD) + J_\mathrm{max} \phi_J PPFD}{0 = \theta_J J ^ 2 - J (J_max + \phi_J PPFD) + J_max \phi_J PPFD}

\tabular{lllll}{
\emph{Symbol} \tab \emph{R} \tab \emph{Description} \tab \emph{Units} \tab \emph{Default}\cr
\eqn{J_\mathrm{max}}{J_max} \tab \code{J_max} \tab potential electron transport (T_leaf) \tab \eqn{\mu}mol CO2 / (m\eqn{^2} s) \tab \link[=bake]{calculated} \cr
\eqn{\phi_J} \tab \code{phi_J} \tab initial slope of the response of J to PPFD \tab none \tab 0.331 \cr
PPFD \tab \code{PPFD} \tab photosynthetic photon flux density \tab \eqn{\mu}mol quanta / (m^2 s) \tab 1500 \cr
\eqn{\theta_J} \tab \code{theta_J} \tab curvature factor for light-response curve \tab none \tab 0.825
}
}
\examples{

library(magrittr)
library(photosynthesis)

bake_par = make_bakepar()
constants = make_constants(use_tealeaves = FALSE)
enviro_par = make_enviropar(use_tealeaves = FALSE)
leaf_par = make_leafpar(use_tealeaves = FALSE)
enviro_par$T_air = leaf_par$T_leaf
leaf_par \%<>\% bake(enviro_par, bake_par, constants)

pars = c(leaf_par, enviro_par, constants)
J(pars, FALSE)
}
