% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy_gcloud.R
\name{legacy_gcloud}
\alias{legacy_gcloud}
\alias{board_register_gcloud}
\title{Google Cloud board (legacy API)}
\usage{
legacy_gcloud(
  bucket = Sys.getenv("GCLOUD_STORAGE_BUCKET"),
  token = NULL,
  cache = NULL,
  name = "gcloud",
  ...
)

board_register_gcloud(
  name = "gcloud",
  bucket = Sys.getenv("GCLOUD_STORAGE_BUCKET"),
  token = NULL,
  cache = NULL,
  path = NULL,
  ...
)
}
\arguments{
\item{bucket}{The name of the Google Cloud Storage bucket. Defaults to the \code{GCLOUD_STORAGE_BUCKET} environment
variable.}

\item{token}{The access token of the Google Cloud Storage container.
Generally, it's best to leave this as \code{NULL}, and rely on the installed
Google Cloud SDK to handle authentication.

If you do want to use an access token, you can retrieve it from
\url{https://developers.google.com/oauthplayground}. You will need to
authorize the "Google Storage API v1" scope.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{name}{An optional name used identify the board. This is no longer
generally needed since you should be passing around an explicit
board object.}

\item{...}{Additional parameters required to initialize a particular board.}

\item{path}{Subdirectory within \code{url}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\details{
To use a Google Cloud Storage board, you first need a Google Cloud Storage
account, a Google Storage bucket, and an access token or the
\href{https://cloud.google.com/sdk}{Google Cloud SDK} properly installed and
configured. You can sign-up and create these from
\url{https://console.cloud.google.com}
}
\examples{
\dontrun{
# the following example requires the Google Cloud SDK to be configured
board <- legacy_gcloud(container = "gcloudcontainer")
}
}
\keyword{internal}
