% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_line_segment}
\alias{image_line_segment}
\title{Line Segment Detection in an Image}
\usage{
image_line_segment(
  img,
  index = "GRAY",
  scale = 0.8,
  sigma_scale = 0.6,
  quant = 2,
  ang_th = 22.5,
  log_eps = 0,
  density_th = 0.7,
  n_bins = 1024,
  union = FALSE,
  union_min_length = 5,
  union_max_distance = 5,
  union_ang_th = 7,
  union_use_NFA = FALSE,
  union_log_eps = 0
)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{index}{A character string with the index to be used. Defaults to \code{"GRAY"}.}

\item{scale}{A positive numeric value. Scales the input image before detection using Gaussian filtering.
A value <1 downscales, >1 upscales. Default is 0.8.}

\item{sigma_scale}{A positive numeric value determining the Gaussian filter sigma.
If scale <1, sigma = sigma_scale / scale; otherwise, sigma = sigma_scale. Default is 0.6.}

\item{quant}{A positive numeric value controlling gradient quantization error. Default is 2.0.}

\item{ang_th}{A numeric value (0-180) defining the gradient angle tolerance in degrees. Default is 22.5.}

\item{log_eps}{A numeric detection threshold. Larger values make detection stricter. Default is 0.0.}

\item{density_th}{A numeric value (0-1) defining the minimum proportion of supporting points in a rectangle. Default is 0.7.}

\item{n_bins}{A positive integer specifying the number of bins for pseudo-ordering gradient modulus. Default is 1024.}

\item{union}{Logical. If TRUE, merges close line segments. Default is FALSE.}

\item{union_min_length}{Numeric. Minimum segment length to merge. Default is 5.}

\item{union_max_distance}{Numeric. Maximum distance between segments to merge. Default is 5.}

\item{union_ang_th}{Numeric. Angle threshold for merging segments. Default is 7.}

\item{union_use_NFA}{Logical. If TRUE, uses NFA in merging. Default is FALSE.}

\item{union_log_eps}{Numeric. Detection threshold for merging. Default is 0.0.}
}
\value{
A list of class \code{lsd} containing:
\itemize{
\item \code{n} - Number of detected line segments.
\item \code{lines} - A matrix with detected segments (columns: x1, y1, x2, y2, width, p, -log_nfa).
\item \code{pixels} - A matrix assigning each pixel to a detected segment (0 = unused pixels).
}
}
\description{
Detects line segments in a digital image using the Line Segment
Detector (LSD), a linear-time method that controls false detections and
requires no parameter tuning. Based on Burns, Hanson, and Riseman's method
with an a-contrario validation approach.
}
\examples{
library(pliman)
}
\references{
Grompone von Gioi, R., Jakubowicz, J., Morel, J.-M., & Randall, G. (2010).
LSD: A Fast Line Segment Detector with a False Detection Control.
IEEE Transactions on Pattern Analysis and Machine Intelligence, 32(4), 722-732.\doi{10.5201/ipol.2012.gjmr-lsd}
}
