% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roccurve.R
\name{ROCCurve}
\alias{ROCCurve}
\title{ROC curve}
\usage{
ROCCurve(
  data,
  truth_by,
  score_by,
  pos_label = NULL,
  split_by = NULL,
  split_by_sep = "_",
  group_by = NULL,
  group_by_sep = "_",
  group_name = NULL,
  x_axis_reverse = FALSE,
  percent = FALSE,
  ci = NULL,
  n_cuts = 0,
  cutoffs_at = NULL,
  cutoffs_labels = NULL,
  cutoffs_accuracy = 0.001,
  cutoffs_pt_size = 5,
  cutoffs_pt_shape = 4,
  cutoffs_pt_stroke = 1,
  cutoffs_labal_fg = "black",
  cutoffs_label_size = 4,
  cutoffs_label_bg = "white",
  cutoffs_label_bg_r = 0.1,
  show_auc = c("auto", "none", "legend", "plot"),
  auc_accuracy = 0.01,
  auc_size = 4,
  theme = "theme_this",
  theme_args = list(),
  palette = "Spectral",
  palcolor = NULL,
  alpha = 1,
  facet_by = NULL,
  facet_scales = "fixed",
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_byrow = TRUE,
  aspect.ratio = 1,
  legend.position = waiver(),
  legend.direction = "vertical",
  title = NULL,
  subtitle = NULL,
  xlab = ifelse(x_axis_reverse, "Specificity", "1 - Specificity"),
  ylab = "Sensitivity",
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  seed = 8525,
  axes = NULL,
  axis_titles = axes,
  guides = NULL,
  design = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{truth_by}{A character string of the column name that contains the true class labels.
(a.k.a. the binary outcome, 1/0 or TRUE/FALSE.)}

\item{score_by}{character strings of the column names that contains the predicted scores.
When multiple columns are provided, the ROC curve is plotted for each column.}

\item{pos_label}{A character string of the positive class label.
When NULL, the labels will be handled by the \code{plotROC} package.}

\item{split_by}{The column(s) to split data by and plot separately.}

\item{split_by_sep}{The separator for multiple split_by columns. See \code{split_by}}

\item{group_by}{Columns to group the data for plotting
For those plotting functions that do not support multiple groups,
They will be concatenated into one column, using \code{group_by_sep} as the separator}

\item{group_by_sep}{The separator for multiple group_by columns. See \code{group_by}}

\item{group_name}{A character string to name the legend of the ROC curve groups.}

\item{x_axis_reverse}{A logical to reverse the x-axis, that is from 1 to 0.}

\item{percent}{A logical to display the x and y axis as percentages.}

\item{ci}{A list of arguments to pass to \code{\link[plotROC:geom_rocci]{plotROC::geom_rocci()}} to add confidence intervals.
When NULL, no confidence intervals are added.}

\item{n_cuts}{An integer to specify the number of cutpoints on the ROC curve.
It will be the quantiles of the predicted scores.}

\item{cutoffs_at}{Vector of user supplied cutoffs to plot as points. If non-NULL,
it will override the values of n_cuts and plot the observed cutoffs closest to the user-supplied ones.
Both \code{cutoffs_at} and \code{cutoffs.labels} will be passed to \code{\link[plotROC:geom_roc]{plotROC::geom_roc()}}.
Other than numeric values, the following special values are allowed. These values are the methods of
\code{\link[OptimalCutpoints:optimal.cutpoints]{OptimalCutpoints::optimal.cutpoints()}}, they are literally:
\itemize{
\item "CB" (cost-benefit method);
\item "MCT" (minimizes Misclassification Cost Term);
\item "MinValueSp" (a minimum value set for Specificity);
\item "MinValueSe" (a minimum value set for Sensitivity);
\item "ValueSe" (a value set for Sensitivity);
\item "MinValueSpSe" (a minimum value set for Specificity and Sensitivity);
\item "MaxSp" (maximizes Specificity);
\item "MaxSe" (maximizes Sensitivity);
\item "MaxSpSe" (maximizes Sensitivity and Specificity simultaneously);
\item "MaxProdSpSe" (maximizes the product of Sensitivity and Specificity or Accuracy Area);
\item "ROC01" (minimizes distance between ROC plot and point (0,1));
\item "SpEqualSe" (Sensitivity = Specificity);
\item "Youden" (Youden Index);
\item "MaxEfficiency" (maximizes Efficiency or Accuracy, similar to minimize Error Rate);
\item "Minimax" (minimizes the most frequent error);
\item "MaxDOR" (maximizes Diagnostic Odds Ratio);
\item "MaxKappa" (maximizes Kappa Index);
\item "MinValueNPV" (a minimum value set for Negative Predictive Value);
\item "MinValuePPV" (a minimum value set for Positive Predictive Value);
\item "ValueNPV" (a value set for Negative Predictive Value);
\item "ValuePPV" (a value set for Positive Predictive Value);
\item "MinValueNPVPPV" (a minimum value set for Predictive Values);
\item "PROC01" (minimizes distance between PROC plot and point (0,1));
\item "NPVEqualPPV" (Negative Predictive Value = Positive Predictive Value);
\item "MaxNPVPPV" (maximizes Positive Predictive Value and Negative Predictive Value simultaneously);
\item "MaxSumNPVPPV" (maximizes the sum of the Predictive Values);
\item "MaxProdNPVPPV" (maximizes the product of Predictive Values);
\item "ValueDLR.Negative" (a value set for Negative Diagnostic Likelihood Ratio);
\item "ValueDLR.Positive" (a value set for Positive Diagnostic Likelihood Ratio);
\item "MinPvalue" (minimizes p-value associated with the statistical Chi-squared test which measures the association between
the marker and the binary result obtained on using the cutpoint);
\item "ObservedPrev" (The closest value to observed prevalence);
\item "MeanPrev" (The closest value to the mean of the diagnostic test values);
\item "PrevalenceMatching" (The value for which predicted prevalence is practically equal to observed prevalence).
}}

\item{cutoffs_labels}{vector of user-supplied labels for the cutoffs. Must be a character vector of the
same length as cutoffs_at.}

\item{cutoffs_accuracy}{A numeric to specify the accuracy of the cutoff values to show.}

\item{cutoffs_pt_size}{A numeric to specify the size of the cutoff points.}

\item{cutoffs_pt_shape}{A numeric to specify the shape of the cutoff points.}

\item{cutoffs_pt_stroke}{A numeric to specify the stroke of the cutoff points.}

\item{cutoffs_labal_fg}{A character string to specify the color of the cutoff labels.}

\item{cutoffs_label_size}{A numeric to specify the size of the cutoff labels.}

\item{cutoffs_label_bg}{A character string to specify the background color of the cutoff labels.}

\item{cutoffs_label_bg_r}{A numeric to specify the radius of the background of the cutoff labels.}

\item{show_auc}{A character string to specify the position of the AUC values.
\itemize{
\item "auto" (default): Automatically determine the position based on the plot.
When there is a single group or 'facet_by' is provided, the AUC is placed on the plot.
Otherwise, the AUC is placed in the legend.
\item "none": Do not display the AUC values.
\item "legend": Display the AUC values in the legend.
\item "plot": Display the AUC values on the plot (left/right bottom corner).
}}

\item{auc_accuracy}{A numeric to specify the accuracy of the AUC values.}

\item{auc_size}{A numeric to specify the size of the AUC values when they are displayed on the plot.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{facet_by}{A character string specifying the column name of the data frame to facet the plot.
Otherwise, the data will be split by \code{split_by} and generate multiple plots
and combine them into one using \code{patchwork::wrap_plots}}

\item{facet_scales}{Whether to scale the axes of facets. Default is "fixed"
Other options are "free", "free_x", "free_y". See \code{ggplot2::facet_wrap}}

\item{facet_ncol}{A numeric value specifying the number of columns in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_nrow}{A numeric value specifying the number of rows in the facet.
When facet_by is a single column and facet_wrap is used.}

\item{facet_byrow}{A logical value indicating whether to fill the plots by row. Default is TRUE.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{seed}{The random seed to use. Default is 8525.}

\item{axes}{A string specifying how axes should be treated. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'keep' will retain all axes in individual plots.
\item 'collect' will remove duplicated axes when placed in the same run of rows or columns of the layout.
\item 'collect_x' and 'collect_y' will remove duplicated x-axes in the columns or duplicated y-axes in the rows respectively.
}}

\item{axis_titles}{A string specifying how axis titltes should be treated. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'keep' will retain all axis titles in individual plots.
\item 'collect' will remove duplicated titles in one direction and merge titles in the opposite direction.
\item 'collect_x' and 'collect_y' control this for x-axis titles and y-axis titles respectively.
}}

\item{guides}{A string specifying how guides should be treated in the layout. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'collect' will collect guides below to the given nesting level, removing duplicates.
\item 'keep' will stop collection at this level and let guides be placed alongside their plot.
\item 'auto' will allow guides to be collected if a upper level tries, but place them alongside the plot if not.
}}

\item{design}{Specification of the location of areas in the layout, passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE. When specified, \code{nrow}, \code{ncol}, and \code{byrow} are ignored.
See \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}} for more details.}

\item{...}{Additional arguments.}
}
\value{
A \code{patch_work::wrap_plots} object or a list of them if \code{combine} is \code{FALSE}.
You can retrieve the AUC values using \code{attr(p, "auc")} if \code{combine} is \code{TRUE}.
If \code{combine} is \code{FALSE}, The AUC value of each plot can be retrieved using \code{attr(p[[i]], "auc")}.
}
\description{
A wrapped function around \code{plotROC} package to create ROC curves.
}
\examples{
set.seed(8525)

D.ex <- rbinom(200, size = 1, prob = .5)
M1 <- rnorm(200, mean = D.ex, sd = .65)
M2 <- rnorm(200, mean = D.ex, sd = 1.5)
gender <- c("Male", "Female")[rbinom(200, 1, .49) + 1]

data <- data.frame(D = D.ex, D.str = c("Healthy", "Ill")[D.ex + 1],
  gender = gender, M1 = M1, M2 = M2)

ROCCurve(data, truth_by = "D", score_by = "M1")
# will warn about the positive label
ROCCurve(data, truth_by = "D.str", score_by = "M1")
ROCCurve(data, truth_by = "D", score_by = "M1", increasing = FALSE)
# Multiple ROC curves
ROCCurve(data, truth_by = "D", score_by = c("M1", "M2"), group_name = "Method")
ROCCurve(data, truth_by = "D", score_by = "M1", group_by = "gender", show_auc = "plot")
# Reverse the x-axis and display the axes as percentages
ROCCurve(data, truth_by = "D", score_by = "M1", x_axis_reverse = TRUE, percent = TRUE)
# Pass additional arguments to geom_roc and make the curve black
ROCCurve(data, truth_by = "D", score_by = "M1", n_cuts = 10, palcolor = "black")
# Add confidence intervals
ROCCurve(data, truth_by = "D", score_by = "M1", ci = list(sig.level = .01))
# Facet by a column
ROCCurve(data, truth_by = "D", score_by = "M1", facet_by = "gender")
# Show cutoffs
ROCCurve(data, truth_by = "D", score_by = "M1", cutoffs_at = c(0, "ROC01", "SpEqualSe"))
# Split by a column
p <- ROCCurve(data, truth_by = "D", score_by = "M1", split_by = "gender",
   cutoffs_at = c(0.2, "MaxSpSe"))
p
# Retrieve the AUC values
attr(p, "auc")
# Retrieve the cutoffs
attr(p, "cutoffs")
}
