% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.R
\name{prepare_enrichr_result}
\alias{prepare_enrichr_result}
\title{Process the enrichment results from Enrichr}
\usage{
prepare_enrichr_result(data, dbname = "Database", n_input = NULL)
}
\arguments{
\item{data}{A data frame containing the result by Enrichr.}

\item{dbname}{A character string specifying the name of the database column.}

\item{n_input}{An integer specifying the number of input genes.
Enrichr result doesn't ship with the number of input genes.
You can either provide the number directly or we will infer it. See details.}
}
\value{
A data frame that can be used in \code{EnrichMap}.
}
\description{
Process the enrichment results from Enrichr
}
\details{
In order to use the \code{EnrichMap} and \code{EnrichNetwork} functions and other visualization functions in \code{plotthis},
the enrichment results from Enrichr need to be processed by the \code{prepare_enrichr_result} function.
The following columns are renamed:
\itemize{
\item \code{Term} -> \code{Description}
\item \code{Genes} -> \code{geneID} (separated replaced by \code{/})
\item \code{P.value} -> \code{pvalue}
\item \code{Adjusted.P.value} -> \code{p.adjust}
Additionally, GeneRatio and BgRatio columns are inferred.
From \href{https://maayanlab.cloud/Enrichr/help#background}{enrichr's documentation}, the oddsRatio is defined as:
\verb{oddsRatio = (A * (D - B - C + A) / max((B - A) * (C - A), 1)}, where A is the overlapping genes; B is the total genes in the gene set;
C (n_input) is the genes in input list; D is the total genes in the background.
D is not provided by Enrichr. To infer it, \code{D = oddsRatio * max((B - A) * (C - A), 1) / A + B + C - A}.
\item \code{Overlap = A / B} (from Enrichr)
\item \code{GeneRatio = A / C} (from ClusterProfiler)
\item \code{BgRatio = B / D} (from ClusterProfiler)
\code{C (n_input)}, if not provided, will be inferred when \code{D} for all terms are equal.
When starting inferrence, the minimum value to try will be unique genes in \code{data$Genes}/\code{data$geneID}.
}
}
\keyword{internal}
