% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protein_quant.R
\name{qrollup}
\alias{qrollup}
\title{Applies qrollup function}
\usage{
qrollup(pepData, qrollup_thresh, combine_fn, parallel = TRUE)
}
\arguments{
\item{pepData}{an omicsData object of class 'pepData'}

\item{qrollup_thresh}{numeric value between 0 and 1 inclusive. Peptides above
this threshold are used to roll up to the protein level}

\item{combine_fn}{logical indicating what combine_fn to use, defaults to
median, other option is mean}

\item{parallel}{logical indicating whether or not to use "doParallel" loop in
applying qrollup function. Defaults to TRUE.}
}
\value{
an omicsData object of class 'proData'
}
\description{
This function applies the qrollup method to a pepData object for each unique
protein and returns a proData object.
}
\details{
In the qrollup method, peptides are selected according to a user
  selected abundance cutoff value (qrollup_thresh), and protein abundance is
  set as the mean of these selected peptides.
}
\references{
Polpitiya, A. D., Qian, W.-J., Jaitly, N., Petyuk, V. A., Adkins,
  J. N., Camp, D. G., ... Smith, R. D. (2008). \emph{DAnTE: a statistical
  tool for quantitative analysis of -omics data}. Bioinformatics (Oxford,
  England), 24(13), 1556-1558.
}
