% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_parmsetter_nm.R
\name{nn_theta_def_nm}
\alias{nn_theta_def_nm}
\title{Internal: Define NN THETAs in NONMEM}
\usage{
nn_theta_def_nm(number, theta_start, n_hidden = 5, time_nn = FALSE)
}
\arguments{
\item{number}{(string) Name of the NN, e.g., \dQuote{1} for NN1(...)}

\item{theta_start}{(numeric) Number with which to start the THETA count of NN parameters}

\item{n_hidden}{(numeric) Number of neurons in the hidden layer, default value is 5}

\item{time_nn}{(boolean) Whether the neural network to analyze is a time-dependent neural network or not. Default values is FALSE.}
}
\value{
Vector with all NN parameter THETA definitions for a NN
}
\description{
Define NN THETAS used in the $PK section in NONMEM
}
\details{
Parameter definition in form of lW = THETA(X) with X the next number of THETA \cr
e.g., if \cr
lV = THETA(1) \cr
lkel = THETA(2) \cr
X is equal to 3
}
\author{
Dominic Bräm
}
\keyword{internal}
