% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_theta.R
\name{get_theta}
\alias{get_theta}
\title{Extract structural model parameter estimates and associated information
from a NONMEM output object.}
\usage{
get_theta(x, output = "est", sigdig = 6, sep = "-", est.step = NULL)
}
\arguments{
\item{x}{A NONMEM output object generated using \code{\link{read_nm}}.}

\item{output}{A flag specifying the matrix or matrices to be output. Valid flag values are \code{est} (the default),
\code{se}, \code{rse}, \code{95ci}, or \code{all}.}

\item{sigdig}{Specifies the number of significant digits to be provided (default=6).}

\item{sep}{Specifies the separator character to use for 95\% confidence intervals (default="-").}

\item{est.step}{Specifies which estimation step to return parameters from (default is the last).}
}
\value{
A named vector of NONMEM model parameter estimates, or in the case of \code{all},
a list of named vectors.
}
\description{
Extract structural model parameter estimates and associated information
from a NONMEM output object.
}
\details{
Output options are as follows:
\emph{est} returns a vector of \code{THETA} values.
\emph{se} returns a vector of \code{THETA} standard errors.
\emph{rse} returns a vector of \code{THETA} relative standard errors (\code{se/est*100}).
\emph{95ci} returns a vector of the asymptotic 95\% confidence intervals for the elements of \code{THETA} (\verb{est +/- 1.96*se}).
\emph{all} returns all available \code{THETA} information as a list of named vectors.
}
\examples{
\dontrun{
 nmOutput <- read_nm("run315.xml")
 thetas <- get_theta(nmOutput)
}

}
\seealso{
NONMEM (\url{https://www.iconplc.com/solutions/technologies/nonmem})
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
