% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pop_Gen_Functions.R
\name{TwoLevelGST}
\alias{TwoLevelGST}
\title{Calculate Two-Level GST}
\usage{
TwoLevelGST(G = matrix)
}
\arguments{
\item{G}{A square matrix representing a gene identity matrix.}
}
\value{
A list containing the components of two-level GST including
within-group gene identity, between-group gene identity, and GST values.
}
\description{
This function calculates two-level GST (Nei's standard gene identity)
measure from a gene identity matrix.
}
\examples{
gene_identity_matrix <- matrix(c(
0.3164550, 0.2836333, 0.2760485,
0.2836333, 0.3106084, 0.2867215,
0.2760485, 0.2867215, 0.3338663
), nrow = 3, byrow = TRUE,
dimnames = list(paste0("Sample", 1:3), paste0("Sample", 1:3)))

TwoLevelGST(G=gene_identity_matrix)

}
