% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-decision.R
\name{plot_decision_assurance_curve}
\alias{plot_decision_assurance_curve}
\title{Plot Decision Assurance Curve (Multi-Effect Grid Friendly)}
\usage{
plot_decision_assurance_curve(
  power_results,
  metric = c("direction", "threshold", "rope"),
  p_star = 0.95,
  x_effect = NULL,
  facet_by = NULL,
  effect_filters = NULL,
  effect_weights = NULL,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results}{A list returned by \verb{brms_inla_power*}.}

\item{metric}{Decision metric: "direction", "threshold", or "rope".}

\item{p_star}{Numeric decision threshold in (0,1).}

\item{x_effect}{Name of effect grid column for x-axis (default: first grid column).}

\item{facet_by}{Optional effect grid column(s) to facet by.}

\item{effect_filters}{Optional named list for filtering rows, e.g. list(treatment=0).}

\item{effect_weights}{Optional named numeric vector of weights for selected x_effect values.}

\item{title, subtitle}{Optional plot labels.}
}
\value{
A ggplot object.
}
\description{
Plots the assurance (proportion of simulation runs meeting a
posterior probability decision rule) versus an effect grid variable,
for a given metric ("direction", "threshold", or "rope") at a fixed
decision probability threshold p_star.
}
