% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTraitGram.R
\name{plotTraitGram}
\alias{plotTraitGram}
\title{plotTraitGram}
\usage{
plotTraitGram(treedata_min, treedata_max, node_est, fossils=FALSE, 
which.biovars, path="", use.paleoclimate=TRUE, paleoclimateUser=NULL,
layerAge=c(0:20))
}
\arguments{
\item{treedata_min}{a tree data object with the min estimate of the climate envelope}

\item{treedata_max}{a tree data object with the max estimate of the climate envelope}

\item{node_est}{the estimate of all the nodes, both min and max}

\item{fossils}{a matrix with four columns of min age, max age, longitude, and latitude, in that order, and rows that are entries for fossil occurrences.}

\item{which.biovars}{A vector of the numbers of the bioclimate variables that should be returned. The bioclimate variables number correspond to the Hijmans table at (https://www.worldclim.org/data/bioclim.html).}

\item{path}{path to the directory where the results should be saved}

\item{use.paleoclimate}{if left blank, default North America paleoclimate data is used. If FALSE, user submitted paleoclimate must be provided}

\item{paleoclimateUser}{list of data frames with paleoclimates, must be dataframes with columns: GlobalID, Longitude, Latitude, bio1, bio2,...,bio19. (see \code{getBioclimvars()}).}

\item{layerAge}{vector with the ages of the paleoclimate dataframes, if using user submitted paleoclimate data}
}
\value{
a trait gram for minimum and maximum of biovariables
}
\description{
Combine the node estimates based on random or specified fossil placement and plot them on a phylotraitgram in a specified directory.
}
\examples{
data(sampletrees)
data(occurrences)
bounds <- list(sigsq = c(min = 0, max = 1000000))
ex_mytree <- sampletrees[[3]] #single tree
\donttest{test_con <- ppgmConsensus(occurrences = occurrences, trees = ex_mytree, 
which.biovars = 1, bounds = bounds, control = list(niter = 20))}
\dontrun{plotTraitGram(test_con$treedata_min,test_con$treedata_max,test_con$node_est)}
}
\seealso{
plotTraitGramMultiPhylo
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard
}
