#'
#' Poverty Probability Index (PPI) Lookup Tables
#'
#' The Poverty Probability Index (PPI) is a poverty measurement tool for
#' organizations and businesses with a mission to serve the poor. The PPI is
#' statistically-sound, yet simple to use: the answers to 10 questions about a
#' household’s characteristics and asset ownership are scored to compute the
#' likelihood that the household is living below the poverty line – or above by
#' only a narrow margin.
#'
#' @docType package
#' @keywords internal
#' @name ppitables
#' @importFrom tibble tibble
#' @importFrom tidyr pivot_longer
#'
"_PACKAGE"


utils::globalVariables(c("poverty_definition", "ppi"))
