% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_mozambique.R
\docType{data}
\name{ppiMOZ2024}
\alias{ppiMOZ2024}
\title{Poverty Probability Index (PPI) lookup table for Mozambique}
\format{
A data frame with 6 columns and 101 rows:
\describe{
  \item{\code{score}}{PPI score}
  \item{\code{percentile20}}{Below 20th percentile poverty line}
  \item{\code{percentile40}}{Below 40th percentile poverty line}
  \item{\code{percentile50}}{Below 50th percentile poverty line}
  \item{\code{percentile60}}{Below 60th percentile poverty line}
  \item{\code{percentile80}}{Below 80th percentile poverty line}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiMOZ2024
}
\description{
The latest version of the PPI for Mozambique was created in June 2024 by
Innovations for Poverty Action (IPA) based on data from the 2022 Demographic
and Health Survey (DHS).
}
\examples{
  # Access Mozambique PPI table
  ppiMOZ2024

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiMOZ2024[ppiMOZ2024$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities
  # corresponding to specific PPI score
  ppiScore <- 50
  subset(ppiMOZ2024, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line is used
  ppiScore <- 50
  ppiMOZ2024[ppiMOZ2024$score == ppiScore, "percentile80"]

}
\keyword{datasets}
