% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repelAxisLabels.R
\name{repelAxisLabels}
\alias{repelAxisLabels}
\title{Distribute Axis Label Locations to Avoid Overlap.}
\usage{
repelAxisLabels(side, at, labels, ..., spacing = "", reduceCex = TRUE)
}
\arguments{
\item{side}{Integer giving the side of the plot, as in graphics::axis.}

\item{at}{The points at which the axis labels and tickmarks would ordinarily be plotted.}

\item{labels}{Character vector of axis labels.}

\item{...}{Other arguments passed to strheight and strwidth, for example font.}

\item{spacing}{Character string giving any spacing desired between the adjacent labels.
Defaults to an empty string.}

\item{reduceCex}{Logical indicating whether axis labels should be shrunk in size if
they don't all fit. Defaults to TRUE.}
}
\value{
List containing the fields "originalAt", "at", and "cex.axis". "originalAt" is
the input parameter "at" that has been sorted, "at" is a vector of new axis locations,
and "cex.axis" is the cex value used to fit the labels without overlap (only necessary
if reduceCex is TRUE).
}
\description{
Distribute Axis Label Locations to Avoid Overlap.
}
\note{
This function is experimental and just uses simple heuristics instead of
any physics logic. It worked the one time I wanted it but if it doesn't
generalise well I may not invest the time to try improving it.

Also note that this function does not work when a plot is resized; you will have to
re-run it after resizing.
}
\author{
Jasper Watson
}
