% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmer_pi.R
\name{lmer_pi}
\alias{lmer_pi}
\title{Prediction intervals for future observations based on linear random effects models (DEPRECATED)}
\usage{
lmer_pi(
  model,
  newdat = NULL,
  m = NULL,
  alternative = "both",
  alpha = 0.05,
  nboot = 10000,
  lambda_min = 0.01,
  lambda_max = 10,
  traceplot = TRUE,
  n_bisec = 30
)
}
\arguments{
\item{model}{a random effects model of class \code{"lmerMod"}}

\item{newdat}{a \code{data.frame} with the same column names as the historical data
on which the model depends}

\item{m}{number of future observations}

\item{alternative}{either "both", "upper" or "lower". \code{alternative} specifies
if a prediction interval or an upper or a lower prediction limit should be computed}

\item{alpha}{defines the level of confidence (1-\code{alpha})}

\item{nboot}{number of bootstraps}

\item{lambda_min}{lower start value for bisection}

\item{lambda_max}{upper start value for bisection}

\item{traceplot}{if \code{TRUE}: plot for visualization of the bisection process}

\item{n_bisec}{maximal number of bisection steps}
}
\value{
If \code{newdat} is specified: A \code{data.frame} that contains the future data,
 the historical mean (hist_mean), the calibrated coefficient (quant_calib),
 the prediction standard error (pred_se), the prediction interval (lower and upper)
 and a statement if the prediction interval covers the future observation (cover).

 If \code{m} is specified: A \code{data.frame} that contains the number of future observations (m)
 the historical mean (hist_mean), the calibrated coefficient (quant_calib),
 the prediction standard error (pred_se) and the prediction interval (lower and upper).

 If \code{alternative} is set to "lower": Lower prediction limits are computed instead
 of a prediction interval.

 If \code{alternative} is set to "upper": Upper prediction limits are computed instead
 of a prediction interval.

 If \code{traceplot=TRUE}, a graphical overview about the bisection process is given.
}
\description{
This function is deprecated. Please use \code{lmer_pi_unstruc()},
\code{lmer_pi_futvec()} or \code{lmer_pi_futmat()}.
}
\details{
This function returns a bootstrap calibrated prediction interval
\deqn{[l,u] = \hat{y} \pm q \sqrt{\hat{var}(\hat{y} - y)}}
with \eqn{\hat{y}} as the predicted future observation,
\eqn{y} as the observed future observations, \eqn{\sqrt{\hat{var}(\hat{y} - y)}}
as the prediction standard error and \eqn{q} as the bootstrap calibrated coefficient that
approximates a quantile of the multivariate t-distribution. \cr
Please note that this function relies on linear random effects models that are
fitted with \code{lmer()} from the lme4 package. Random effects have to be specified as
\code{(1|random_effect)}.\cr
}
\examples{

# This function is deprecated.
# Please use lmer_pi_unstruc() if you want exactly the same functionality.
# Please use lmer_pi_futmat() or lmer_pi_futvec() if you want to take care
# of the future experimental design

}
