% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{arg_match0_true_or_false}
\alias{arg_match0_true_or_false}
\title{Match an argument to a \code{TRUE} or \code{FALSE} vector but skip \code{NA}}
\usage{
arg_match0_true_or_false(
  arg,
  allow_na = TRUE,
  arg_nm = rlang::caller_arg(arg),
  error_call = rlang::caller_env()
)
}
\arguments{
\item{arg}{A symbol referring to an argument accepting strings.}

\item{allow_na}{Input boolean to determine if \code{NA} or \code{NaN} is allowed.
Default: \code{TRUE}}

\item{arg_nm}{Same as \code{error_arg}.}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
The \code{TRUE} or \code{FALSE} value supplied to \code{arg}.
}
\description{
This is equivalent to \code{\link[rlang]{arg_match}} but a
boolean variable is needed and skip \code{NA}.
}
\examples{
# No error
input = TRUE
arg_match0_true_or_false(input)

# Allow NA
input = NA
arg_match0_true_or_false(input)

# Error as 0 is not TRUE or FALSE
input = 0
try(arg_match0_true_or_false(input))

# Error as 1 is not TRUE or FALSE
input = 1
try(arg_match0_true_or_false(input))

# Error as NULL is not TRUE or FALSE
input = NULL
try(arg_match0_true_or_false(input))

# Error as NA is not TRUE or FALSE and allow_na is FALSE
input = NA
try(arg_match0_true_or_false(input, allow_na = FALSE))
}
