% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anonymize_names.R
\name{anonymize_names}
\alias{anonymize_names}
\title{Anonymize Patient Names}
\usage{
anonymize_names(x, prefix = "Patient", seed = NULL, use_uuid = TRUE)
}
\arguments{
\item{x}{A character vector of names to anonymize}

\item{prefix}{A character string to prefix anonymized names (default: "Patient")}

\item{seed}{An optional seed for reproducible anonymization}

\item{use_uuid}{Logical, if TRUE uses short UUIDs instead of sequential IDs
(default: TRUE).}
}
\value{
A character vector of anonymized names
}
\description{
Replaces patient names with anonymized identifiers while maintaining
referential integrity (same names get the same anonymized value).
}
\examples{
names <- c("John Doe", "Jane Smith", "Bob Johnson")
anonymize_names(names)
anonymize_names(names, prefix = "PAT", seed = 123)
anonymize_names(names, use_uuid = FALSE, seed = 123)  # Use sequential IDs

}
