% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.prodlim.R
\name{as.data.frame.prodlim}
\alias{as.data.frame.prodlim}
\title{Turn prodlim objects into a data.frame}
\usage{
\method{as.data.frame}{prodlim}(x, ...)
}
\arguments{
\item{x}{object obtained with function \code{\link{prodlim}}}

\item{...}{passed to \code{\link{summary.prodlim}}}
}
\value{
A data.table with the results of the prodlim object
}
\description{
Collect results of a fitted prodlim object in a data.frame
}
\details{
By default object contains results for all fitted time points and all strata.
Use arguments times and newdata of \code{\link{summary.prodlim}} to subset.
}
\examples{
set.seed(8)
d <- SimCompRisk(17)
fit <- prodlim(Hist(time,event)~X1,data=d)
as.data.frame.prodlim(fit)
as.data.frame.prodlim(fit)

}
\seealso{
\code{\link{prodlim}}
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
