% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validWeights.R
\docType{data}
\name{.validWeights}
\alias{.validWeights}
\alias{.isValidWeightTarget}
\alias{.isValidWeightAlias}
\alias{.listValidWeightTargets}
\alias{.listValidWeightAliases}
\title{Valid Weights}
\format{
An object of class \code{list} of length 2.
}
\usage{
.validWeights

.isValidWeightTarget(target)

.isValidWeightAlias(alias)

.listValidWeightTargets()

.listValidWeightAliases()
}
\arguments{
\item{target}{String}

\item{alias}{String}
}
\value{
Logical for \code{.isValid*}, and a string for \code{.listValid*}.
}
\description{
These track and access the weights we support as well as any aliases.
}
\details{
"target" refers to weight calculations we support.

"alias" refers to all possible names. Every "target" has at least one
"alias" (itself) and may have more.

\code{.isValidWeightTarget()} and \code{.isValidWeightAlias()} identify
whether a given input (from a user) is a value weighting name.

\code{.listValidWeightTargets()} and \code{.listValidWeightAliases()} are
for returning nicely formatted strings for messages to users.

IMPORTANT: Adding new aliases MUST correspond to new functions defined in
weights_exported.R, with possible adjustments to calculations in
weights_internal.R.
}
\keyword{internal}
