% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{print.prt}
\alias{print.prt}
\alias{format.prt}
\alias{format_dt}
\alias{trunc_dt}
\title{Printing prt}
\usage{
\method{print}{prt}(x, ..., n = NULL, width = NULL, max_extra_cols = NULL)

\method{format}{prt}(x, ..., n = NULL, width = NULL, max_extra_cols = NULL)

format_dt(
  x,
  ...,
  n = NULL,
  width = NULL,
  max_extra_cols = NULL,
  max_footer_lines = NULL
)

trunc_dt(...)
}
\arguments{
\item{x}{Object to format or print.}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{Number of rows to show. If \code{NULL}, the default, will print all rows
if less than the \code{print_max} \link[pillar:pillar_options]{option}.
Otherwise, will print as many rows as specified by the
\code{print_min} \link[pillar:pillar_options]{option}.}

\item{width}{Width of text output to generate. This defaults to \code{NULL}, which
means use the \code{width} \link[pillar:pillar_options]{option}.}

\item{max_extra_cols}{Number of extra columns to print abbreviated information for,
if the width is too small for the entire tibble. If \code{NULL},
the \code{max_extra_cols} \link[pillar:pillar_options]{option} is used.
The previously defined \code{n_extra} argument is soft-deprecated.}

\item{max_footer_lines}{Maximum number of footer lines. If \code{NULL},
the \code{max_footer_lines} \link[pillar:pillar_options]{option} is used.}
}
\description{
Printing of \code{prt} objects combines the concise yet informative design
of only showing as many columns as the terminal width allows for, introduced
by \code{tibble}, with the \code{data.table} approach of showing both the first and
last few rows of a table. Implementation wise, the interface is designed to
mimic that of \code{tibble} printing as closely as possibly, offering the same
function arguments and using the same option settings (and default values)
as introduced by \code{tibble}.
}
\details{
While the function \code{\link[tibble:trunc_mat]{tibble::trunc_mat()}} does most of the heavy lifting
for formatting \code{tibble} printing output, \code{prt} exports the function
\code{trunc_dt()}, which drives analogous functionality while adding the
top/bottom \code{n} row concept. This function can be used for creating \code{\link[=print]{print()}}
methods for other classes which represent tabular data, given that this
class implements \code{\link[=dim]{dim()}}, \code{\link[utils:head]{utils::head()}} and \code{\link[utils:head]{utils::tail()}} (and
optionally \code{\link[pillar:tbl_sum]{pillar::tbl_sum()}}) methods. For an example of this, see
\href{../doc/prt.html}{\code{vignette("prt", package = "prt")}}.

The following session options are set by \code{tibble} and are respected by
\code{prt}, as well as any other package that were to call \code{trunc_dt()}:
\itemize{
\item \code{tibble.print_max}: Row number threshold: Maximum number of rows printed.
Set to \code{Inf} to always print all rows.  Default: 20.
\item \code{tibble.print_min}: Number of rows printed if row number threshold is
exceeded. Default: 10.
\item \code{tibble.width}: Output width. Default: \code{NULL} (use \code{width} option).
\item \code{tibble.max_extra_cols}: Number of extra columns printed in reduced form.
Default: 100.
}

Both \code{tibble} and \code{prt} rely on \code{pillar} for formatting columns and
therefore, the following options set by \code{pillar} are applicable to \code{prt}
printing as well.
}
\section{Options for the pillar package}{


\itemize{
\item \code{width}: The width option controls the output width.
Setting \code{options(pillar.width = )} to a larger value
will lead to printing in multiple tiers (stacks).
\item \code{pillar.print_max}: Maximum number of rows printed, default: \code{20}.
Set to \code{Inf} to always print all rows.
For compatibility reasons, \code{getOption("tibble.print_max")} and
\code{getOption("dplyr.print_max")} are also consulted,
this will be soft-deprecated in pillar v2.0.0.
\item \code{pillar.print_min}: Number of rows printed if the table has more than
\code{print_max} rows, default: \code{10}.
For compatibility reasons, \code{getOption("tibble.print_min")} and
\code{getOption("dplyr.print_min")} are also consulted,
this will be soft-deprecated in pillar v2.0.0.
\item \code{pillar.width}: Output width. Default: \code{NULL}
(use \code{getOption("width")}).
This can be larger than \code{getOption("width")}, in this case the output
of the table's body is distributed over multiple tiers for wide tibbles.
For compatibility reasons, \code{getOption("tibble.width")} and
\code{getOption("dplyr.width")} are also consulted,
this will be soft-deprecated in pillar v2.0.0.
\item \code{pillar.max_footer_lines}: The maximum number of lines in the footer,
default: \code{7}. Set to \code{Inf} to turn off truncation of footer lines.
The \code{max_extra_cols} option still limits
the number of columns printed.
\item \code{pillar.max_extra_cols}: The maximum number of columns printed in the footer,
default: \code{100}. Set to \code{Inf} to show all columns.
Set the more predictable \code{max_footer_lines} to control the number
of footer lines instead.
\item \code{pillar.bold}: Use bold font, e.g. for column headers? This currently
defaults to \code{FALSE}, because many terminal fonts have poor support for
bold fonts.
\item \code{pillar.subtle}: Use subtle style, e.g. for row numbers and data types?
Default: \code{TRUE}.
\item \code{pillar.subtle_num}: Use subtle style for insignificant digits? Default:
\code{FALSE}, is also affected by the \code{subtle} option.
\item \code{pillar.neg}: Highlight negative numbers? Default: \code{TRUE}.
\item \code{pillar.sigfig}: The number of significant digits that will be printed and
highlighted, default: \code{3}. Set the \code{subtle} option to \code{FALSE} to
turn off highlighting of significant digits.
\item \code{pillar.min_title_chars}: The minimum number of characters for the column
title, default: \code{20}.  Column titles may be truncated up to that width to
save horizontal space. Set to \code{Inf} to turn off truncation of column
titles.
\item \code{pillar.min_chars}: The minimum number of characters wide to
display character columns, default: \code{3}.  Character columns may be
truncated up to that width to save horizontal space. Set to \code{Inf} to
turn off truncation of character columns.
\item \code{pillar.max_dec_width}: The maximum allowed width for decimal notation,
default: \code{13}.
\item \code{pillar.bidi}: Set to \code{TRUE} for experimental support for bidirectional scripts.
Default: \code{FALSE}. When this option is set, "left right override"
and "first strong isolate"
\href{https://www.w3.org/International/questions/qa-bidi-unicode-controls}{Unicode controls}
are inserted to ensure that text appears in its intended direction
and that the column headings correspond to the correct columns.
\item \code{pillar.superdigit_sep}: The string inserted between superscript digits
and column names in the footnote. Defaults to a \code{"\u200b"}, a zero-width
space, on UTF-8 platforms, and to \code{": "} on non-UTF-8 platforms.
\item \code{pillar.advice}: Should advice be displayed in the footer when columns or rows
are missing from the output? Defaults to \code{TRUE} for interactive sessions,
and to \code{FALSE} otherwise.
}

}

\examples{
cars <- as_prt(mtcars)

print(cars)
print(cars, n = 2)
print(cars, width = 30)
print(cars, width = 30, max_extra_cols = 2)

}
