% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_surv_pem.R
\name{outcome_surv_pem}
\alias{outcome_surv_pem}
\title{Piecewise exponential survival distribution}
\usage{
outcome_surv_pem(
  time_var,
  cens_var,
  baseline_prior,
  weight_var = "",
  cut_points
)
}
\arguments{
\item{time_var}{character. Name of time variable column in model matrix}

\item{cens_var}{character. Name of the censorship variable flag in model matrix}

\item{baseline_prior}{\code{Prior}. Object of class \code{Prior}
specifying prior distribution for each cut point.
See \code{Details} for more information.}

\item{weight_var}{character. Optional name of variable in model matrix for weighting the log likelihood.}

\item{cut_points}{numeric. Vector of internal cut points for the piecewise exponential model. Note: the choice of
cut points will impact the amount of borrowing between arms when dynamic borrowing methods are selected. It is
recommended to choose cut points that contain an equal number of events within each interval. Please include only internal
cut points in the vector. For instance, for cut points of [0, 15], (15, 20], (20, Inf), the vector should be c(15, 20).
If you pass cut-points beyond the follow-up of the data, you will receive an informative warning when calling
\code{create_analysis_object()} and these cut points will be ignored.}
}
\value{
Object of class \code{\link[=OutcomeSurvPEM-class]{OutcomeSurvPEM}}.
}
\description{
Piecewise exponential survival distribution
}
\details{
\subsection{Baseline Prior}{

The \code{baseline_prior} argument specifies the prior distribution for the
baseline log hazard rate within each cutpoint. Currently, there is no option to
consider different baseline priors within each cut point.
The interpretation of the \code{baseline_prior} differs
slightly between borrowing methods selected.
\itemize{
\item \emph{Dynamic borrowing using \code{borrowing_hierarchical_commensurate()}}: the \code{baseline_prior} for Bayesian Dynamic Borrowing
refers to the log hazard rate of the external control arm.
\item \emph{Full borrowing} or \emph{No borrowing} using \code{borrowing_full()} or \code{borrowing_none()}: the \code{baseline_prior} for
these borrowing methods refers to the log hazard rate for the internal control arm.
}
}
}
\examples{
es <- outcome_surv_pem(
  time_var = "time",
  cens_var = "cens",
  baseline_prior = prior_normal(0, 1000),
  cut_points = c(10, 15, 30)
)
}
\seealso{
Other outcome models: 
\code{\link{outcome_bin_logistic}()},
\code{\link{outcome_cont_normal}()},
\code{\link{outcome_surv_exponential}()},
\code{\link{outcome_surv_weibull_ph}()}
}
\concept{outcome models}
