% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{datatrade_NorthAm}
\alias{datatrade_NorthAm}
\title{Example Trade Data for Northern America}
\format{
A list of four data frames:
\itemize{
\item \strong{extra_import} \verb{ } Data on imports from countries outside of
Northern America. A data frame with 100 rows and 4 columns:
\tabular{lll}{
\code{reporter} \tab \verb{ } \tab ISO 3166-1 alpha-2 code of the importing country.\cr
\tab \cr
\code{partner} \tab \verb{ } \tab ID of the exporting country, coded as
"CNTR_1" to "CNTR_5" to represent specific  non-Northern American countries.\cr
\tab \cr
\code{time_period} \tab \verb{ } \tab Time period of trade, in three-month
periods ("January-March", "April-June", "July-September", "October-December").\cr
\tab \cr
\code{value} \tab \verb{ } \tab Quantity of the commodity imported.\cr
}}
\itemize{
\item \strong{intra_trade} \verb{ } Data on internal trade within Northern American countries.
A data frame with 80 rows and 4 columns:
\tabular{lll}{
\code{reporter} \tab \verb{ } \tab ISO 3166-1 alpha-2 code of the importing
country.\cr \tab \cr
\code{partner} \tab \verb{ } \tab ISO 3166-1 alpha-2 code  of the exporting
country.\cr \tab \cr
\code{time_period} \tab \verb{ } \tab Time period of trade, in three-month
periods ("January-March", "April-June", "July-September", "October-December").\cr
\tab \cr
\code{value} \tab \verb{ } \tab Quantity of the commodity imported.\cr
}}
\itemize{
\item \strong{internal_production} \verb{ } Data on the internal production of the commodity
within Northern America. A data frame with 20 rows and 3 columns:
\tabular{lll}{
\code{reporter} \tab \verb{ } \tab ISO 3166-1 alpha-2 code of the producing
country.\cr \tab \cr
\code{time_period} \tab \verb{ } \tab Time period of trade, in three-month
periods ("January-March", "April-June", "July-September", "October-December").\cr
\tab \cr
\code{value} \tab \verb{ } \tab Quantity of the commodity produced.\cr
}}
\itemize{
\item \strong{consumption_iso2} \verb{ } Data on the consumption of the commodity in
Northern America at ISO 3166-2 level (principal subdivisions of countries).
A data frame with 83 rows and 2 columns:
\tabular{lll}{
\code{iso_3166_2} \tab \verb{ } \tab ISO 3166-2 code of the subdivision.\cr
\tab \cr
\code{value} \tab \verb{ } \tab Quantity of the commodity consumed.\cr
}}
}
\usage{
datatrade_NorthAm
}
\description{
Simulated trade data for a commodity within Northern America.
This dataset illustrates the trade and production flow of a commodity that could
serve as a potential pathway for the entry of a pest into Northern American
countries. The data is organised in three-month periods within a year.
It also includes simulated consumption data of the commodity at at the level of
principal sub-national divisions (ISO 3166-2 codes).
This dataset serves as a reference on how the data should be structured and provides
the basis for the examples included in the \link{qPRAentry} package to deal with the ISO
3166 code system
(\href{https://www.iso.org/iso-3166-country-codes.html}{ISO 3166 Maintenance Agency}).
}
\keyword{datasets}
