% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_compare.R
\name{loo_compare}
\alias{loo_compare}
\title{Compare models by LOO (default) or WAIC}
\usage{
loo_compare(..., criterion = c("loo", "waic"), sort = TRUE)
}
\arguments{
\item{...}{One or more fitted models (qbrms/qbrmO), or \code{loo} objects; you
can also pass a single named list of models.}

\item{criterion}{Character, "loo" (default) or "waic".}

\item{sort}{Logical; if TRUE (default) the best model is first.}
}
\value{
A data.frame with model names, estimate on the ELPD scale
(higher is better), standard error (if available), differences vs best,
and ranks.
}
\description{
Compare multiple fitted models and rank them by out-of-sample fit.
If you pass qbrms/qbrmO fit objects, this uses the package's \code{loo()}
/ \code{waic()} wrappers under the hood. If you pass actual \code{loo}
objects (from the \pkg{loo} package), it will delegate to
\code{loo::loo_compare()} automatically.
}
