% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_builder.R
\name{model_builder}
\alias{model_builder}
\title{Interactive Model Builder for qbrms (console)}
\usage{
model_builder(data = NULL, response = NULL, predictors = NULL, quiet = FALSE)
}
\arguments{
\item{data}{A data frame containing the variables to be modelled (optional).
If not provided, the user will be prompted to specify it.}

\item{response}{Character string specifying the response variable name (optional).}

\item{predictors}{Character vector of predictor variable names (optional).}

\item{quiet}{Logical; if TRUE, suppresses welcome messages (default: FALSE).}
}
\value{
An object with class \code{"qbrms_model_spec"} containing:
\itemize{
\item \code{formula}: The model formula
\item \code{family}: A list with \code{name} and the constructed family \code{object}
\item \code{prior}: Prior specifications (if provided)
\item \code{data}: The data frame
\item \code{data_name}: The symbol used for data in the emitted code
\item \code{model_code}: Character string with executable qbrms code
\item \code{response_info}: Summary information about the response
}
}
\description{
An interactive assistant that guides users through model specification by
asking questions about their data, suggesting appropriate families, helping
with prior selection, and building qbrms model code.
}
\examples{
\dontrun{
spec <- model_builder()
fit <- eval(parse(text = spec$model_code))
}

}
