% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcrlscR.R
\docType{package}
\name{qcrlscR-package}
\alias{qcrlscR}
\alias{qcrlscR-package}
\title{qcrlscR: Quality Control–based Robust LOESS Signal Correction}
\description{
\code{qcrlscR} implements quality control–based robust LOESS
signal correction for metabolomics data analysis.
}
\section{Main functions}{

The \code{qcrlscR} provides functions for metabolomics data signal correction.
It allows users to optimise \code{span} for LOESS in the range of 0.05 and
0.95. This package also provides simple functions for
missing value filtering. If the data set used for signal correction has
large portion of missing values, users need to filter the data based on
percentage of missing values. A straightforward batch shifting function is
provided for batch elimination if the batch effects are still present
after QC-SLRC process. User can use other R packages's PCA plot
(un-supervised) or PLS and LDA plots (supervised) to assess the goodness
of signal correction.
}

\section{Package context}{

This package does not use "tidyverse" and only uses basic R for
simplicity and easy maintenance. A vignette (in R and PDF format) is
located in \verb{\\qcrlsc\\examples}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/wanchanglin/qcrlscR}
  \item Report bugs at \url{https://github.com/wanchanglin/qcrlscR/issues}
}

}
\author{
\strong{Maintainer}: Wanchang Lin \email{wanchanglin@hotmail.com}

Authors:
\itemize{
  \item Warwick Dunn
}

}
\keyword{internal}
