% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.2.R
\name{sqr}
\alias{sqr}
\title{Spline Quantile Regression (SQR) by formula}
\usage{
sqr(
  formula,
  tau = seq(0.1, 0.9, 0.2),
  spar = NULL,
  d = 1,
  data,
  subset,
  na.action,
  model = TRUE,
  weighted = FALSE,
  mthreads = TRUE,
  method = c("AIC", "BIC"),
  ztol = 1e-05
)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms, separated by + operators, on the right.}

\item{tau}{sequence of quantile levels in (0,1)}

\item{spar}{smoothing parameter: if \code{spar=NULL}, smoothing parameter is selected by \code{method}}

\item{d}{subsampling rate of quantile levels (default = 1)}

\item{data}{a data.frame in which to interpret the variables named in the formula}

\item{subset}{an optional vector specifying a subset of observations to be used}

\item{na.action}{a function to filter missing data (see \code{rq} in the 'quantreg' package)}

\item{model}{if \code{TRUE} then the model frame is returned (needed for calling \code{summary} subsequently)}

\item{weighted}{if \code{TRUE}, penalty function is weighted (default = \code{FALSE})}

\item{mthreads}{if \code{FALSE}, set \code{RhpcBLASctl::blas_set_num_threads(1)} (default = \code{TRUE})}

\item{method}{a criterion for smoothing parameter selection if \code{spar=NULL} (\code{"AIC"} or \code{"BIC"})}

\item{ztol}{a zero tolerance parameter used to determine the effective dimensionality of the fit}
}
\value{
object of SQR fit
}
\description{
This function computes spline quantile regression (SQR) solution from response vector and design matrix.
It uses the FORTRAN code \code{rqfnb.f} in the "quantreg" package with the kind permission of Dr. R. Koenker.
}
\examples{
library(quantreg)
data(engel)
engel$income <- engel$income - mean(engel$income)
tau <- seq(0.1,0.9,0.05)
fit <- rq(foodexp ~ income,tau=tau,data=engel)
fit.sqr <- sqr(foodexp ~ income,tau=tau,spar=0.5,data=engel)
par(mfrow=c(1,1),pty="m",lab=c(10,10,2),mar=c(4,4,2,1)+0.1,las=1)
plot(tau,fit$coef[2,],xlab="Quantile Level",ylab="Coeff1")
lines(tau,fit.sqr$coef[2,])
}
