% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_data.R
\name{market_data}
\alias{market_data}
\title{Produces component and quality scores.}
\usage{
market_data(
  companies = qmj::companies_r3k16,
  financials = qmj::financials_r3k16,
  prices = qmj::prices_r3k16
)
}
\arguments{
\item{companies}{A data frame of company names and 
tickers.}

\item{financials}{A data frame containing financial 
information for the given companies.}

\item{prices}{A data frame containing the daily 
market closing prices and returns.}
}
\value{
A data frame containing company names, tickers, 
profitability z-scores, growth z-scores, safety z-scores,
payout z-scores, and quality z-scores. Organized by
quality in descending order.

data.frame of all market data
}
\description{
Calculates market growth, payouts, safety, and 
profitability of our list of companies for later 
processing.
}
\details{
All parameters default to package data sets and must
be formatted similarly to a data frame produced by
\code{\link{tidy_prices}} and \code{\link{tidyinfo}}.
}
\examples{
\donttest{
# Takes more than 10 secs
market_data(companies_r3k16[companies_r3k16$ticker \%in\% c("AAPL"), ])
}

}
\seealso{
\code{\link{market_profitability}}

\code{\link{market_growth}}

\code{\link{market_safety}}

\code{\link{market_payouts}}
}
