% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_export.R
\name{import_export}
\alias{import_export}
\alias{import_data}
\alias{export_data}
\title{High Level Import From And Export To CSV And XLSX}
\usage{
import_data(
  infile,
  sheet = 1,
  region = NULL,
  separator = "auto",
  decimal = "auto",
  var_names = TRUE
)

export_data(
  data_frame,
  outfile,
  separator = ";",
  decimal = ",",
  var_names = TRUE
)
}
\arguments{
\item{infile}{Full file path with extension to a csv or xlsx file to be imported.}

\item{sheet}{Only used in xlsx import. Which sheet of the workbook to import.}

\item{region}{Only used in xlsx import. Can either be an 'Excel' range like 'A1:BY27'
or the name of a named region.}

\item{separator}{Only used in CSV-export. Defines the single character value separator.}

\item{decimal}{Only used in CSV-export. Defines the single character decimal character.}

\item{var_names}{TRUE by default. Whether to export variable names or not.}

\item{data_frame}{A data frame to export.}

\item{outfile}{Full file path with extension. Allowed extensions are ".csv" and ".xlsx".}
}
\value{
Returns a data frame.
}
\description{
\code{\link[=import_data]{import_data()}}: A wrapper for \code{\link[data.table:fread]{data.table::fread()}} and \code{\link[openxlsx2:wb_to_df]{openxlsx2::wb_to_df()}},
providing basic import functionality with minimal code.

\code{\link[=export_data]{export_data()}}: A wrapper for \code{\link[data.table:fwrite]{data.table::fwrite()}} and \code{\link[openxlsx2:wb_save]{openxlsx2::wb_save()}},
providing basic export functionality with minimal code.
}
\details{
\code{\link[=import_data]{import_data()}} and \code{\link[=export_data]{export_data()}} are based on the 'SAS' procedures Proc Import and Proc Export,
which provide a very straight forward syntax. While 'SAS' can import many different formats with
these procedures, these 'R' versions concentrate on importing CSV and XLSX files.

The main goal here is to just provide as few as possible parameters to tackle most of the imports
and exports. These error handling also tries to let an import and export happen, even though
a parameter wasn't provided in the correct way.
}
\examples{
# Example files
csv_file  <- system.file("extdata", "qol_example_data.csv",  package = "qol")
xlsx_file <- system.file("extdata", "qol_example_data.xlsx", package = "qol")

# Import: Provide full file path
my_csv  <- import_data(csv_file)
my_xlsx <- import_data(xlsx_file)

# Import specific regions
range_import <- import_data(xlsx_file, region = "B4:H32")
name_import  <- import_data(xlsx_file, region = "test_region")

# Import from another sheet
sheet_import <- import_data(xlsx_file, sheet = "Sheet 2")

# Example data frame
my_data <- dummy_data(100)

# Example export file paths
export_csv  <- tempfile(fileext = ".csv")
export_xlsx <- tempfile(fileext = ".xlsx")

# Export: Provide full file path
my_data |> export_data(export_csv)
my_data |> export_data(export_xlsx)

# Manual cleanup for example
unlink(c(export_csv, export_xlsx))

}
\seealso{
Functions that can export with style: \code{\link[=frequencies]{frequencies()}}, \code{\link[=crosstabs]{crosstabs()}}, \code{\link[=any_table]{any_table()}},
\code{\link[=export_with_style]{export_with_style()}}.

Creating a custom table style: \code{\link[=excel_output_style]{excel_output_style()}}, \code{\link[=modify_output_style]{modify_output_style()}},
\code{\link[=number_format_style]{number_format_style()}}, \code{\link[=modify_number_formats]{modify_number_formats()}}.

Global style options: \code{\link[=set_style_options]{set_style_options()}}, \code{\link[=set_variable_labels]{set_variable_labels()}}, \code{\link[=set_stat_labels]{set_stat_labels()}}.
}
