% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlong_to_qk_functions.R
\name{tileXY_to_quadkey}
\alias{tileXY_to_quadkey}
\title{Convert tile XY coordinates into a QuadKey.}
\usage{
tileXY_to_quadkey(tileX, tileY, zoom)
}
\arguments{
\item{tileX}{Tile X coordinate.}

\item{tileY}{Tile Y coordinate.}

\item{zoom}{Zoom or level of detail,
from 1 (lowest detail) to 23 (highest detail).}
}
\value{
The QuadKey as a string.
}
\description{
Converts tile XY coordinates into a QuadKey at a specified
zoom level.
For further information, refer to the Microsoft Bing Maps Tile System
documentation.
}
\details{
Converting latitude/longitude coordinates into a QuadKey
and then back to latitude/longitude won't yield identical values,
unless the initial latitude/longitude coordinates
correspond to the upper-left Quadkey's pixel and tile XY coordinates
at the same zoom level.

Understanding this distinction is crucial for
the accurate use of these functions in coordinate conversions.

For a detailed explanation on how to use this
and other similar \code{quadkeyr} functions,
read the the vignette:
\url{https://docs.ropensci.org/quadkeyr/articles/quadkey_to_sf_conversion.html}
}
\examples{

tileXY_to_quadkey(
  tileX = 23,
  tileY = 38,
  zoom = 6
)

}
\references{
\url{https://learn.microsoft.com/en-us/bingmaps/articles/bing-maps-tile-system}
}
