% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{quarto_update_extension}
\alias{quarto_update_extension}
\title{Update a Quarto extensions}
\usage{
quarto_update_extension(
  extension = NULL,
  no_prompt = FALSE,
  quiet = FALSE,
  quarto_args = NULL
)
}
\arguments{
\item{extension}{The extension to update, either by its name (i.e \verb{ quarto update extension <gh-org>/<gh-repo>}), an archive (\verb{ quarto update extension <path-to-zip>}) or a url (\verb{quarto update extension <url>}).}

\item{no_prompt}{Do not prompt to confirm approval to download external extension. Setting \code{no_prompt = FALSE} means \href{#extension-trust}{Extension Trust} is accepted.}

\item{quiet}{Suppress warning and other messages, from R and also Quarto CLI
(i.e \code{--quiet} is passed as command line).

\code{quarto.quiet} \R option or \code{R_QUARTO_QUIET} environment variable can be used to globally override a function call
(This can be useful to debug tool that calls \verb{quarto_*} functions directly).

On Github Actions, it will always be \code{quiet = FALSE}.}

\item{quarto_args}{Character vector of other \code{quarto} CLI arguments to append
to the Quarto command executed by this function. This is mainly intended for
advanced usage and useful for CLI arguments which are not yet mirrored in a
dedicated parameter of this \R function. See \verb{quarto render --help} for options.}
}
\value{
Returns invisibly \code{TRUE} if the extension was updated, \code{FALSE} otherwise.
}
\description{
Update an extension to this folder or project by running \verb{quarto update}
}
\section{Extension Trust}{
Quarto extensions may execute code when documents are rendered. Therefore, if
you do not trust the author of an extension, we recommend that you do not
install or use the extension.
By default \code{no_prompt = FALSE} which means that
the function will ask for explicit approval when used interactively, or
disallow installation.
}

\examples{
\dontrun{
# Update a template and set up a draft document from a GitHub repository
quarto_update_extension("quarto-ext/fontawesome")

# Update a template and set up a draft document from a ZIP archive
quarto_update_extension("https://github.com/quarto-ext/fontawesome/archive/refs/heads/main.zip")
}
}
\seealso{
\code{\link[=quarto_add_extension]{quarto_add_extension()}}, \code{\link[=quarto_remove_extension]{quarto_remove_extension()}}, and \href{https://quarto.org/docs/extensions/managing.html}{Quarto website}.
}
