% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4.2_Mix_designs_Classes.R
\name{mixDesign.c}
\alias{mixDesign.c}
\title{mixDesign-class: Class `mixDesign`}
\description{
mixDesign class for simplex lattice and simplex centroid mixture designs with optional center points and augmented points.
}
\seealso{
\code{\link{mixDesign}}, \code{\link{contourPlot3}}, \code{\link{wirePlot3}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Character string representing the name of the design.}

\item{\code{factors}}{List of factors involved in the mixture design, including their levels and settings.}

\item{\code{total}}{Numeric value representing the total number of runs in the design.}

\item{\code{lower}}{Numeric vector representing the lower bounds of the factors in the design.}

\item{\code{design}}{Data frame containing the design matrix for the mixture design.}

\item{\code{designType}}{Character string specifying the type of design (e.g., "simplex-lattice", "simplex-centroid").}

\item{\code{pseudo}}{Data frame containing pseudo-experimental runs if applicable.}

\item{\code{response}}{Data frame containing the responses or outcomes measured in the design.}

\item{\code{Type}}{Data frame specifying the type of design used (e.g., "factorial", "response surface").}

\item{\code{block}}{Data frame specifying block structures if the design is blocked.}

\item{\code{runOrder}}{Data frame specifying the order in which runs are performed.}

\item{\code{standardOrder}}{Data frame specifying the standard order of the runs.}

\item{\code{desireVal}}{List of desired values or targets for the response variables.}

\item{\code{desirability}}{List of desirability scores or metrics based on the desired values.}

\item{\code{fits}}{Data frame containing the fitted model parameters and diagnostics.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-mixDesign.c-.factors}{\code{mixDesign.c$.factors()}}
\item \href{#method-mixDesign.c-names}{\code{mixDesign.c$names()}}
\item \href{#method-mixDesign.c-as.data.frame}{\code{mixDesign.c$as.data.frame()}}
\item \href{#method-mixDesign.c-print}{\code{mixDesign.c$print()}}
\item \href{#method-mixDesign.c-.response}{\code{mixDesign.c$.response()}}
\item \href{#method-mixDesign.c-.nfp}{\code{mixDesign.c$.nfp()}}
\item \href{#method-mixDesign.c-summary}{\code{mixDesign.c$summary()}}
\item \href{#method-mixDesign.c-units}{\code{mixDesign.c$units()}}
\item \href{#method-mixDesign.c-lows}{\code{mixDesign.c$lows()}}
\item \href{#method-mixDesign.c-highs}{\code{mixDesign.c$highs()}}
\item \href{#method-mixDesign.c-clone}{\code{mixDesign.c$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-.factors"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-.factors}{}}}
\subsection{Method \code{.factors()}}{
Get and set the \code{factors} in an object of class \code{mixDesign}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$.factors(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New factors, If missing value get the \code{factors}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-names"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-names}{}}}
\subsection{Method \code{names()}}{
Get and set the \code{names} in an object of class \code{mixDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$names(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New names, If missing value get the \code{names}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-as.data.frame"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-as.data.frame}{}}}
\subsection{Method \code{as.data.frame()}}{
Methods for function \code{as.data.frame} in Package \code{base}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$as.data.frame()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-print"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-print}{}}}
\subsection{Method \code{print()}}{
Methods for function \code{print} in Package \code{base}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-.response"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-.response}{}}}
\subsection{Method \code{.response()}}{
Get and set the the \code{response} in an object of class \code{mixDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$.response(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New response, If missing value get the \code{response}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-.nfp"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-.nfp}{}}}
\subsection{Method \code{.nfp()}}{
Prints a summary of the factors attributes including their low, high, name, unit, and type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$.nfp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-summary"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-summary}{}}}
\subsection{Method \code{summary()}}{
Methods for function \code{summary} in Package \code{base}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-units"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-units}{}}}
\subsection{Method \code{units()}}{
Get and set the \code{units} for the factors in an object of class \code{mixDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$units(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New units, If missing value get the \code{units}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-lows"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-lows}{}}}
\subsection{Method \code{lows()}}{
Get and set the \code{lows} for the factors in an object of class \code{mixDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$lows(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New lows, If missing value get the \code{lows}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-highs"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-highs}{}}}
\subsection{Method \code{highs()}}{
Get and set the \code{highs} for the factors in an object of class \code{mixDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$highs(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New highs, If missing value get the \code{highs}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mixDesign.c-clone"></a>}}
\if{latex}{\out{\hypertarget{method-mixDesign.c-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{mixDesign.c$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
