% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.3_Taguchi_designs_Functions.R
\name{oaChoose}
\alias{oaChoose}
\title{oaChoose: Taguchi Designs}
\usage{
oaChoose(factors1, factors2, level1, level2, ia)
}
\arguments{
\item{factors1}{Number of factors on level1.}

\item{factors2}{Number of factors on level2.}

\item{level1}{Number of levels on level1.}

\item{level2}{Number of levels on level2.}

\item{ia}{Number of interactions.}
}
\value{
\code{oaChoose} returns an object of class \code{taguchiDesign}.
}
\description{
Shows a matrix of possible taguchi designs.
}
\details{
\code{oaChoose} returns possible taguchi designs. Specifying the number of factor1 factors with level1 levels (factors1 = 2, level1 = 3 means 2 factors with 3 factor levels) and factor2 factors with level2 levels and desired interactions one or more taguchi designs are suggested.
If all parameters are set to `0`, a matrix of possible taguchi designs is shown.
}
\examples{
oaChoose()
}
\seealso{
\itemize{
\item{\code{\link{facDesign}}: for 2^k factorial designs.}
\item{\code{\link{rsmDesign}}: for response surface designs.}
\item{\code{\link{fracDesign}}: for fractional factorial design.}
\item{\code{\link{gageRRDesign}}: for gage designs.}
}
}
