% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3_Distr_DistrCollection_Functions.R
\name{qqPlot}
\alias{qqPlot}
\title{qqPlot: Quantile-Quantile Plots for various distributions}
\usage{
qqPlot(
  x,
  y,
  confbounds = TRUE,
  alpha,
  main,
  xlab,
  ylab,
  xlim,
  ylim,
  border = "red",
  bounds.col = "black",
  bounds.lty = 1,
  start,
  showPlot = TRUE,
  axis.y.right = FALSE,
  bw.theme = FALSE
)
}
\arguments{
\item{x}{The sample for qqPlot.}

\item{y}{Character string specifying the distribution of \code{x}. The function \code{qqPlot} supports the following character strings for \code{y}:
\itemize{
  \item{\code{`beta`}}
  \item{\code{`cauchy`}}
  \item{\code{`chi-squared`}}
  \item{\code{`exponential`}}
  \item{\code{`f`}}
  \item{\code{`gamma`}}
  \item{\code{`geometric`}}
  \item{\code{`log-normal`}}
  \item{\code{`lognormal`}}
  \item{\code{`logistic`}}
  \item{\code{`negative binomial`}}
  \item{\code{`normal`}}
  \item{\code{`Poisson`}}
  \item{\code{`weibull`}}
}
By default \code{distribution} is set to \code{`normal`}.}

\item{confbounds}{Logical value indicating whether to display confidence bounds. By default, \code{confbounds} is set to \code{TRUE}.}

\item{alpha}{Numeric value specifying the significance level for the confidence bounds, set to `0.05` by default.}

\item{main}{A character string for the main title of the plot.}

\item{xlab}{A character string for the x-axis label.}

\item{ylab}{A character string for the y-axis label.}

\item{xlim}{A numeric vector of length 2 to specify the limits of the x-axis.}

\item{ylim}{A numeric vector of length 2 to specify the limits of the y-axis.}

\item{border}{A numerical value or single character string giving the color of the interpolation line. By default, \code{border} is set to \code{`red`}.}

\item{bounds.col}{A numerical value or single character string giving the color of the confidence bounds lines. By default, \code{bounds.col} is set to \code{`black`}.}

\item{bounds.lty}{A numeric or character: line type for the confidence bounds lines. This can be specified with either an integer (0-6) or a name:
\itemize{
  \item{0: blank}
  \item{1: solid}
  \item{2: dashed}
  \item{3: dotted}
  \item{4: dotdash}
  \item{5: longdash}
  \item{6: twodash}
}
Default is `1` (solid line).}

\item{start}{A named list giving the parameters to be fitted with initial values. Must be supplied for some distributions (see Details).}

\item{showPlot}{Logical value indicating whether to display the plot. By default, \code{showPlot} is set to \code{TRUE}.}

\item{axis.y.right}{Logical value indicating whether to display the y-axis on the right side. By default, \code{axis.y.right} is set to \code{FALSE}.}

\item{bw.theme}{Logical value indicating whether to use a black-and-white theme from the \code{ggplot2} package for the plot. By default, \code{bw.theme} is set to \code{FALSE}.}
}
\value{
The function \code{qqPlot} returns an invisible list containing:
\item{x}{Sample quantiles.}
\item{y}{Theoretical quantiles.}
\item{int}{Intercept of the fitted line.}
\item{slope}{Slope of the fitted line.}
\item{plot}{The generated QQ plot.}
}
\description{
Function \code{qqPlot} creates a QQ plot of the values in x including a line which passes through the first and third quartiles.
}
\details{
Distribution fitting is performed using the \code{FitDistr} function from this package.
For the computation of the confidence bounds, the variance of the quantiles is estimated using the delta method,
which involves the estimation of the observed Fisher Information matrix as well as the gradient of the CDF of the fitted distribution.
Where possible, those values are replaced by their normal approximation.
}
\examples{
set.seed(123)
qqPlot(rnorm(20, mean=90, sd=5), "normal",alpha=0.30)
qqPlot(rcauchy(100), "cauchy")
qqPlot(rweibull(50, shape = 1, scale = 1), "weibull")
qqPlot(rlogis(50), "logistic")
qqPlot(rlnorm(50) , "log-normal")
qqPlot(rbeta(10, 0.7, 1.5),"beta")
qqPlot(rpois(20,3), "poisson")
qqPlot(rchisq(20, 10),"chi-squared")
qqPlot(rgeom(20, prob = 1/4), "geometric")
qqPlot(rnbinom(n = 20, size = 3, prob = 0.2), "negative binomial")
qqPlot(rf(20, df1 = 10, df2 = 20), "f")
}
\seealso{
\code{\link{ppPlot}}, \code{\link{FitDistr}}.
}
