% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_CategoryAxis.R
\name{initialize,CategoryAxis-method}
\alias{initialize,CategoryAxis-method}
\alias{categoryAxis}
\alias{setGridPosition}
\alias{setGridPosition,CategoryAxis,character-method}
\title{Initializes a CategoryAxis}
\usage{
\S4method{initialize}{CategoryAxis}(.Object, gridPosition, guides, ...)

categoryAxis(gridPosition, ...)

setGridPosition(.Object, gridPosition)

\S4method{setGridPosition}{CategoryAxis,character}(.Object, gridPosition)
}
\arguments{
\item{.Object}{\linkS4class{CategoryAxis}.}

\item{gridPosition}{\code{character}, 
specifies if a grid line is placed on the center of a cell or on the beginning of a cell.
Possible values are: "start" and "middle"
This setting doesn't work if parseDates is set to TRUE.}

\item{guides}{\code{list} of \linkS4class{Guide}.}

\item{...}{Other properties.}
}
\description{
Initializes or update a \linkS4class{CategoryAxis}.
}
\examples{
guides <- list(guide(fillAlpha = .4, adjustBorderColor = TRUE),
               guide(fillAlpha = .4, adjustBorderColor = TRUE))
new("CategoryAxis", gridPosition = "start",  gridThickness = 1, guides = guides)

\dontrun{
new("CategoryAxis")
new("CategoryAxis", gridPosition = "start", 1) # 1 is not take into account
}

categoryAxis(gridPosition = "start", adjustBorderColor = TRUE)

setGridPosition(.Object = categoryAxis(), gridPosition = "start")
}
