
      SUBROUTINE Biomasse(BdatBart,D13,D2,H2,H,Biom)
      INTEGER BdatBart
      real D13,D2,H2,H,Biom
!         ====================================================


      Biom=FnBiomasse(BdatBart,D13,D2,H2,H)
      End SUBROUTINE Biomasse


!**************************************************************************************************

      real Function FNBiomasse(BdatBart,D13,D2,H2,H)

!         =======================================================
      implicit none
      INTEGER BdatBart
      real D13,D2,H2,H
      real erg
      INTEGER ba_nr, i
      real d13_us
      real xFNBDATDmRHx
      real fHoehenTarif

      real b0_h(1:18), b1_h(1:18), Bo(1:18), B_us(1:18)
      real b3_poly(1:18), b0(1:18), b1(1:18), b2(1:18)
      real b3(1:18), k1(1:18), k2(1:18), d13_os(1:18)
      real c0(1:18), c1(1:18), a(1:18), b(1:18)
      INTEGER bio_bagr(300),iErr

      real B_os, d03, d03_os, h_os

      data d13_us /10/

      data (b0_h(i),i=1,18) /
     1    0.230589, 0.230589, 0.230589, 0.230589, 0.230589, 0.049402,
     1    0.049402, 0.049402, 0.049402, 0.049402, 0.049402, 0.049402,
     1    0.049402, 0.049402, 0.049402, 0.049402, 0.049402, 0.049402
     1    /

      data (b1_h(i),i=1,18) /
     1    2.201010, 2.201010, 2.201010, 2.201010, 2.201010, 2.549462,
     1    2.549462, 2.549462, 2.549462, 2.549462, 2.549462, 2.549462,
     1    2.549462, 2.549462, 2.549462, 2.549462, 2.549462, 2.549462
     1    /

      data (Bo(i),i=1,18) /
     1    0.410799, 0.410799, 0.410799, 0.410799, 0.410799, 0.096436,
     1    0.096436, 0.096436, 0.096436, 0.096436, 0.096436, 0.096436,
     1    0.096436, 0.096436, 0.096436, 0.096436, 0.096436, 0.096436
     1    /

      data (B_us(i),i=1,18) /
     1    26.631220, 19.122312, 19.117109, 19.999435, 28.339055,
     1    33.223278, 28.947819, 33.748928, 38.949475, 30.795513,
     1    33.090857, 22.414603, 41.656504, 33.975677, 28.289641,
     1    19.888007, 16.861011, 21.785135
     1    /

      data (b3_poly(i),i=1,18) /
     1    0.013696, -0.000710, -0.002753, 0.009158, 0.027686, 0.011621,
     1    0.015009, 0.026795, 0.023861, 0.024696, 0.029672, 0.006530,
     1    0.041933, 0.025661, 0.019265, 0.001053, -0.005509, 0.005165
     1    /

      data (b0(i),i=1,18) /
     1    0.752848, 0.063943, 0.054267, 0.337783, 0.141263, 0.167871,
     1    0.094279, 0.140114, 0.348054, 0.207830, 0.206695, 0.110756,
     1    0.627748, 0.191710, 0.210419, 0.138305, 0.272778, 0.299783
     1    /

      data (b1(i),i=1,18) /
     1    2.849849, 4.112771, 5.531211, 2.840552, 4.419252, 6.254522,
     1    10.269984, 4.917100, 5.512190, 4.379202, 3.944298, 5.176043,
     1    3.971093, 4.202065, 4.387211, 4.463595, 4.192402, 4.755305
     1    /

      data (b2(i),i=1,18) /
     1    6.030355, 6.692779, 9.259898, 6.349639, 6.294424, 6.647523,
     1    8.138936, 6.285623, 5.829990, 6.294122, 6.113504, 6.965050,
     1    5.135899, 6.656169, 5.439829, 5.947719, 5.962976, 6.365869
     1    /

      data (b3(i),i=1,18) /
     1    0.621878, 1.058685, 0.890083, 0.627555, 0.883409, 0.807451,
     1    0.558449, 0.905214, 0.884464, 0.859312, 0.862962, 0.852889,
     1    0.870941, 0.779942, 0.806097, 0.850972, 0.810312, 0.786933
     1    /

      data (k1(i),i=1,18) /
     1    42.00, 6.00,   5.50, 18.00, 6.40, 11.00,
     1    400.00, 9.00, 157.60, 10.00, 9.40, 8.70,
     1    67.60, 8.20, 68.40, 11.10, 13.70, 13.20
     1    /

      data (k2(i),i=1,18) /
     1    24.0, 62.70, 139.20, 23.00, 68.60, 135.0,
     1    8.0, 70.60, 13.00, 61.50, 46.30, 90.90,
     1    18.60, 53.10, 10.10, 50.70, 66.80, 85.80
     1    /

      data (d13_os(i),i=1,18) /
     1    69.00, 90.00, 82.00, 59.00, 70.00, 86.0,
     1    94.00, 77.00, 55.00, 68.00, 69.00, 84.0,
     1    75.00, 85.00, 53.00, 58.00, 113.00, 102.0
     1    /

      data (c0(i),i=1,18) /
     1    1.078434, 1.173719, 1.068712, 0.890090, 1.200444, 0.840135,
     1    0.876335, 0.828197, 0.801798, 0.864267, 0.748943, 0.830802,
     1    0.980605, 1.035449, 1.030980, 0.936909, 0.867197, 0.828710
     1    /

      data (c1(i),i=1,18) /
     1    0.912040, 0.898113, 0.906065, 0.957474, 0.880278, 0.989704,
     1    0.982788, 0.991109, 1.000543, 0.975139, 1.021867, 0.990512,
     1    0.935437, 0.926549, 0.904414, 0.944473, 0.961536, 0.986861
     1    /

      data (a(i),i=1,18) /
     1    0.274072, 0.277236, 0.259403, 0.297216, 0.276316, 0.293966,
     1    0.315672, 0.300388, 0.332180, 0.314044, 0.317395, 0.311777,
     1    0.322445, 0.326550, 0.321719, 0.322696, 0.280639, 0.345238
     1    /

      data (b(i),i=1,18) /
     1    2.220311, 2.397463, 2.928833, 1.986882, 2.459936, 1.768945,
     1    1.633350, 1.535308, 1.281238, 1.532003, 1.344200, 1.729393,
     1    1.490083, 1.292453, 1.575659, 1.496584, 2.402878, 1.695635
     1    /

! 	Transformation BDatbaumart in Biomassebaumart
      data( bio_bagr(i),i=1,36)  /
     1    1,1,2,2,4,4,4,3,5,5,5,1,1,1,6,9,7,7,17,17,8,10,10,11,10,15,
     1    12,16,6,14,13,6,6,18,6,6/



      if(BdatBart .le.0 .or. BdatBart .gt.36)then
          Bdatbart=1
      endif

      ba_nr=bio_bagr(BdatBart)

      if(d2.le.0) then
          d2=0
          H2=50
      endif
      d03=xFNBDATDmRHx(BdatBart, d13, 0.0, d2, H2, H, H*0.3, IErr, d03)


      d03_os= d03 + c0(ba_nr) * d13_os(ba_nr)**c1(ba_nr) -
     1    c0(ba_nr) * d13**c1(ba_nr)
      h_os = h + fHoehenTarif(a(ba_nr), b(ba_nr), d13_os(ba_nr))
     1    - fHoehenTarif(a(ba_nr), b(ba_nr), d13)

      if (h < 1.3) then
          erg = b0_h(ba_nr) * h**b1_h(ba_nr)
      else if ( d13 < d13_us) then

          erg =  Bo(ba_nr) + ((B_us(ba_nr) - Bo(ba_nr)) /
     1    (d13_us*d13_us) + b3_poly(ba_nr) * (d13 - d13_us)) *
     2    d13**2

      else if ( d13 < d13_os(ba_nr)) then

          erg= b0(ba_nr) *
     1    exp( b1(ba_nr)  * d13 / (d13 + k1(ba_nr))) *
     1    exp( b2(ba_nr)  * d03 / (d03 + k2(ba_nr))) * h** b3(ba_nr)

      else

! 	e1=exp(b1(ba_nr) * d13_os(ba_nr) / (d13 + k1(ba_nr)))
! 	e2=exp(b2(ba_nr) * d03_os / (d03_os + k2(ba_nr)))
! 	h3=h_os** b3(ba_nr)

          B_os=b0(ba_nr) *
     1    exp(b1(ba_nr) * d13_os(ba_nr)/(d13_os(ba_nr)+k1(ba_nr)))
     2    * exp(b2(ba_nr) * d03_os / (d03_os + k2(ba_nr)))
     3    * h_os** b3(ba_nr)

          erg = B_os * (1 + b1(ba_nr) * k1(ba_nr) /
     1        ((d13_os(ba_nr) + k1(ba_nr))** 2) *
     2        (d13 - d13_os(ba_nr)) +
     3        b2(ba_nr) * k2(ba_nr) / ((d03_os + k2(ba_nr))**2)
     4        * (d03 - d03_os) + b3(ba_nr) / h_os * (h - h_os))

      end if

      FNBiomasse=erg


      end function FNBiomasse

!****************************************************************************************


      real function fHoehenTarif(a, b, d13)
      implicit none
      real a,b,d13

          fHoehenTarif= 1.3 + 1 / (a + b / d13)**3
      end function fHoehenTarif
