% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizers.R
\name{cluster_heatmap}
\alias{cluster_heatmap}
\title{Cluster-wise Heatmap of Missing Data Patterns}
\usage{
cluster_heatmap(
  data,
  clusters,
  cols_ignore = NULL,
  show_row_names = TRUE,
  missing_color = "black",
  observed_color = "white",
  title = "Missingness Heatmap by Cluster"
)
}
\arguments{
\item{data}{A \code{data.frame} or tibble containing the dataset with possible
missing values. Rows represent observations and columns represent features.}

\item{clusters}{A vector of cluster labels for each observation (row) in
\code{data}. Must have the same length as \code{nrow(data)}.}

\item{cols_ignore}{Optional character vector of column names in \code{data} to
exclude from the heatmap (e.g., identifiers or non-feature columns).}

\item{show_row_names}{Logical. If TRUE, displays feature names on plot}

\item{missing_color}{Display color of missing values. Default black.}

\item{observed_color}{Display color of observed values. Default white.}

\item{title}{Optional plot title. Defaults to "Missingness Heatmap by Cluster"}
}
\value{
A list of class \code{"ComplexHeatmap"} containing the heatmap
object. This can be used for further inspection or manual redraw.
}
\description{
Visualize the pattern of missing values in a dataset, arranged by cluster. Each
column in the heatmap represents one observation and each row a feature. Tiles
indicate whether a value is missing (black) or present (white). Cluster labels
are shown as a column annotation bar above the heatmap. The package
\pkg{ComplexHeatmap} must be installed for this function to work.
}
\details{
This function constructs a binary missingness matrix where 1 indicates a
missing value and 0 a present value. Columns (observations) are ordered by
their cluster labels, and the function displays a heatmap of missingness
patterns using \pkg{ComplexHeatmap}. Cluster membership is displayed as an
annotation above the heatmap.
}
\examples{
if(requireNamespace("ComplexHeatmap")){
# Simple example with small dataset
df <- data.frame(
  x1 = c(1, NA, 3),
  x2 = c(NA, 2, 3),
  x3 = c(1, 2, NA)
)
cl <- c("A", "B", "A")
cluster_heatmap(df, cl)

# Example excluding a column prior to plotting
cluster_heatmap(df, cl, cols_ignore = "x2")

# Adding a 'Cluster' label and changing colors
cluster_heatmap(df, clusters = paste0("Cluster ", cl), cols_ignore = "x2", 
missing_color = "red", observed_color = "blue")
}

}
