% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.PCA.r
\name{MVP.PCA}
\alias{MVP.PCA}
\title{Principal Component Analysis}
\usage{
MVP.PCA(
  M = NULL,
  K = NULL,
  maxLine = 10000,
  ind_idx = NULL,
  mrk_idx = NULL,
  mrk_bycol = TRUE,
  pcs.keep = 5,
  cpu = 1,
  verbose = TRUE
)
}
\arguments{
\item{M}{genotype, either m by n or n by m is supportable, m is marker size, n is population size}

\item{K}{kinship matrix}

\item{maxLine}{the number of markers handled at a time, smaller value would reduce the memory cost}

\item{ind_idx}{the index of effective genotyped individuals used in analysis}

\item{mrk_idx}{the index of effective markers used in analysis}

\item{mrk_bycol}{whether the markers are stored by columns in genotype (i.e. M is a n by m matrix)}

\item{pcs.keep}{maximum number of PCs for output}

\item{cpu}{the number of cpu}

\item{verbose}{whether to print detail.}
}
\value{
Output: PCs - a n * npc matrix of top number of PCs, n is population size and npc is @param pcs.keep
}
\description{
Principal Component Analysis
}
\examples{
\donttest{
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
print(dim(genotype))

pca <- MVP.PCA(M=genotype, cpu=1)
str(pca)
}

}
