% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{rp_get_greeks}
\alias{rp_get_greeks}
\title{Get Option Greeks}
\usage{
rp_get_greeks(accountId, osiOptionSymbol)
}
\arguments{
\item{accountId}{= Public Brokerage Account Number}

\item{osiOptionSymbol}{= option symbol}
}
\value{
Request order cancellation & return as a \code{data.frame}.
}
\description{
Get Option Greeks
}
\examples{
\dontrun{
 # get account number
 my_acc <- rp_getAccts()
 
 # build option symbol
 this_op = .rp_make_opt_symbol(under_sym = "SPY", exp = "2025-08-22", 
                               type = "P", strike = 600)
 
 # get greeks
 rp_get_greeks(accountId = my_acc$accountId, osiOptionSymbol = this_op) 
}
}
