% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intrinsic.R
\name{update.intrinsicCBrSPDEobj}
\alias{update.intrinsicCBrSPDEobj}
\title{Update parameters of intrinsicCBrSPDEobj objects}
\usage{
\method{update}{intrinsicCBrSPDEobj}(object, kappa = NULL, tau = NULL, alpha = NULL, beta = NULL, ...)
}
\arguments{
\item{object}{Model object created by \code{\link[=intrinsic.matern.operators]{intrinsic.matern.operators()}}}

\item{kappa}{kappa value to be updated.}

\item{tau}{tau value to be update.}

\item{alpha}{alpha value to be updated.}

\item{beta}{beta value to be updated. .}

\item{...}{currently not used.}
}
\value{
An object of type intrinsicCBrSPDEobj with updated parameters.
}
\description{
Function to change the parameters of a intrinsicCBrSPDEobj object
}
\examples{
if (requireNamespace("RSpectra", quietly = TRUE)) {
  x <- seq(from = 0, to = 10, length.out = 201)
  beta <- 1
  alpha <- 1
  kappa <- 1
  op <- intrinsic.matern.operators(
    kappa = kappa, tau = 1, alpha = alpha,
    beta = beta, loc_mesh = x, d = 1
  )
op <- update(op, beta = 1.1, alpha = 0.9) 
}
}
