% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RN_plot_spectrum.R
\name{RN_plot_spectrum}
\alias{RN_plot_spectrum}
\title{Plot radionuclide emission spectra directly from ICRP-107 data.}
\usage{
RN_plot_spectrum(
  desired_RN,
  rad_type = NULL,
  photon = FALSE,
  log_plot = 0,
  prob_cut = 0.01
)
}
\arguments{
\item{desired_RN}{Radionuclide in form "Ba-137m"}

\item{rad_type}{Radiation type, leave NULL if selecting photons or
select from:

'X' for X-Ray

'G' for Gamma

'AE' for Auger Electron

'IE' for Internal Conversion Electron

'A' for Alpha

'AR' for Alpha Recoil

'B-' for Beta Negative

'AQ' for Annihilation Quanta

'B+' for Beta Positive

'PG' for Prompt Gamma

'DG' for Delayed Gamma

'DB' for Delayed Beta

'FF' for Fission Fragment

'N' for Neutron}

\item{photon}{Use only if you do not specify \code{rad_type}.
TRUE will select all rad_types that are photons.
Note that if you select \code{rad_type = "G"}, for example, you
will not get X-rays or Annihilation Quanta (the 0.511 MeV
photon from pair annihilation).}

\item{log_plot}{0 = no log axes,

1 (default) = log y-axis,

2 = log both axes.

This argument is ignored for B- plots.}

\item{prob_cut}{minimum probability defaults to 0.01}
}
\value{
plot of spectrum
}
\description{
Plot emission spectra based on radionuclide and desired radiation type.
Plot on log axes if desired.
Select cutoff value for probability optional, included at 1\% by default.
Plot includes energy times probability for dosimetric importance comparisons.
}
\examples{
RN_plot_spectrum(
  desired_RN = c("Sr-90", "Y-90"), rad_type = "B-",
  photon = FALSE, prob_cut = 0.01
)
RN_plot_spectrum(
  desired_RN = c("Co-60", "Ba-137m"), rad_type = NULL,
  photon = TRUE, prob_cut = 0.015
)
RN_plot_spectrum(
  desired_RN = c("Co-60", "Ba-137m"), rad_type = NULL,
  photon = TRUE, log_plot = 0
)
RN_plot_spectrum(desired_RN = c("Co-60", "Ba-137m"), rad_type = "G")
RN_plot_spectrum(
  desired_RN = c("Pu-238", "Pu-239", "Am-241"), rad_type = "A",
  photon = FALSE, prob_cut = 0.01, log_plot = 0
)
}
\seealso{
Other radionuclides: 
\code{\link{RN_Spec_Act}()},
\code{\link{RN_bin_screen_phot}()},
\code{\link{RN_index_screen}()},
\code{\link{RN_info}()},
\code{\link{RN_plot_df}()},
\code{\link{RN_plot_search_results}()},
\code{\link{RN_save_spectrum}()},
\code{\link{RN_search_alpha_by_E}()},
\code{\link{RN_search_beta_by_E}()},
\code{\link{RN_search_phot_by_E}()}
}
\concept{radionuclides}
