% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{ragnar_retrieve_bm25}
\alias{ragnar_retrieve_bm25}
\title{Retrieves chunks using the BM25 score}
\usage{
ragnar_retrieve_bm25(
  store,
  text,
  top_k = 3L,
  ...,
  k = 1.2,
  b = 0.75,
  conjunctive = FALSE,
  filter
)
}
\arguments{
\item{store}{A \code{RagnarStore} object returned by \code{ragnar_store_connect()} or \code{ragnar_store_create()}.}

\item{text}{String, the text to search for.}

\item{top_k}{Integer. Number of nearest entries to find per method.}

\item{...}{Additional arguments passed to the lower-level retrieval functions.}

\item{k, b}{\eqn{k_1} and \eqn{b} parameters in the Okapi BM25 retrieval method.}

\item{conjunctive}{Whether to make the query conjunctive i.e., all terms in
the query string must be present in order for a chunk to be retrieved.}

\item{filter}{Optional. A filter expression evaluated with \code{dplyr::filter()}.}
}
\value{
A tibble ordered by descending BM25 \code{metric_value} (higher is more
relevant), with a \code{metric_name} column set to "bm25".
}
\description{
BM25 refers to Okapi Best Matching 25. See \doi{10.1561/1500000019} for more
information.
}
\seealso{
Other ragnar_retrieve: 
\code{\link{ragnar_retrieve}()},
\code{\link{ragnar_retrieve_vss}()},
\code{\link{ragnar_retrieve_vss_and_bm25}()}
}
\concept{ragnar_retrieve}
