% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tes.R
\name{tes}
\alias{tes}
\title{Calculation of Total Expected Species base on ESa, ESb and their average value}
\usage{
tes(x)
}
\arguments{
\item{x}{a data vector representing number of individuals for each species}
}
\value{
a list in a self-defined class 'rarestr'. See "Details".
}
\description{
Calculation of Total Expected Species base on ESa, ESb and their average value
}
\details{
The value returned by the \code{tes()} function in the 'rarestr' class is a list containing three parts:
\describe{
\item{par}{A data frame of the summary of the estimated values and their standard deviations based on TESa, TESb, and TESab, and the model used in the estimation of TES, either 'logistic' or 'Weibull'.}
\item{TESa}{A list of the modeled results with the TESa method.}
\item{TESb}{A list of the modeled results with the TESb method.}
}
Both TESa and TESb contain five parts, including a data frame of the parameters (\code{$par}), a data frame of the simulated results (\code{$result}), a maximum x value (\code{$xmax}), a vector of the predicted x value (\code{$Predx}), and a vector of the predicted y value (\code{$Predy})
}
\examples{
data(share, package = 'rarestR')
Output_tes <- tes(share[1,])
Output_tes
}
\references{
\insertRef{zou2025}{rarestR}
}
